#!/usr/bin/perl -s

################################################################################
# To make "ug" directory and ug/genome.txt
# 
#
################################################################################
use strict;
use File::Path;
use FileHandle;
use DirHandle;
use GenBank;
use MBGD;
use MbgdUserGenomeCommon;
require "MBGD_Conf.pl";
require "MBGD_commonUpdate.pl";

################################################################################
#
sub MakeUgDir {
    my($uid, $formOpt, $spid) = @_;
    my$dirSpid = "$main::DIR_species/$spid";
    my$dirUg   = "$dirSpid/gu";

    unless (-e $dirUg) {
	mkpath("$dirUg", 0, 0750);
    }

    my($fileLastUpdate) = "$dirUg/last_update";
    new FileHandle(">$fileLastUpdate");

    MbgdUserGenomeCommon::saveUserGenomeInfo($uid, $formOpt);

    return;
}
################################################################################
#
sub MakeUgChromosomeData {
    my($spid) = shift;
    my$dirSpid = "$main::DIR_species/$spid";
    my$dirUg   = "$dirSpid/gu";
    my$dirUgData = "$dirUg/data";
    my$dirGm   = "$dirSpid/gm";
    my$dirGmData   = "$dirGm/data";

    unless (-e $dirUgData) {
	mkpath("$dirUgData", 0, 0750);
    }

    my(@chlist) = glob("$dirGmData/?.protseq");
    push (@chlist, glob("$dirGmData/??.protseq"));

    my($fileStatus) = "statusOk";

    my($chrnum) = scalar @chlist;
    for(my$i=1;$i<=$chrnum;$i++) {
	my$dirUc = $dirUgData . "/chr" . sprintf("%02.d", $i);
	mkpath("$dirUc", 0, 0750);
	
	new FileHandle(">$dirUc/$fileStatus");
    }
    return;
}

################################################################################
sub warning_out {
    my($message,$type,$count) = @_;
    print STDERR "WARNING: $message\n";
    $count->{"warnings_$type"}++;
}

################################################################################

sub MakeOptHush {
    my($spid) = shift;
    my$dirSpid = "$main::DIR_species/$spid";
    my$dirGm   = "$dirSpid/gm";
    my$filename = "genome.txt";
    #print STDERR "$dirGm\n";
    my($formOpt) = {};
    $spid =~ /gu(\d+)/;
    $formOpt->{'id_user_genome'} = $1 + 0;

    my($fh) = new FileHandle("$dirGm/$filename") || die("Can not open $filename($!)");

    while(<$fh>) {
        chomp();
	split;
	if ($_[0] eq 'orgname') {
	    $formOpt->{'species_name'} = $_[1];
	} elsif ($_[0] eq 'abbrev') {
	    $formOpt->{'abbreviation_name'} = $_[1];
	} elsif ($_[0] eq 'taxid') {
	    $formOpt->{'taxonomy_id'} = $_[1];
	} elsif ($}[0] eq 'strain') {
	    $formOpt->{'strain'} = $_[1];
	} else {
	    next;
	}
    }
    $fh->close();
    return $formOpt;
}


################################################################################
package main;

if ($0 eq __FILE__) {
    my($sp);
    my($cmd);
    my($uid) = $<;

    # STDERR ˽ϤƤե˽
    &openLogfile();
    my($refSpid) = getInfoSpecTab("$ENV{'MBGD_HOME'}/etc/spid.tab");
    #
    my(@spidList) = @ARGV;
    if ($main::ALL) {
        @spidList = sort(keys(%{$refSpid->{'SPID2DIR'}}));
    }

    #
 
    foreach my$spid (@spidList) {
        my($sp) = $refSpid->{'SPID2NAME'}->{"$spid"};
        print STDERR "Start :: $spid($sp)\n";
	my($formOpt) = &MakeOptHush($spid);
        &MakeUgDir($uid, $formOpt, $spid);
	&MakeUgChromosomeData($spid);
    }

    exit();
}

################################################################################
1;#
################################################################################
