#!/usr/bin/perl -s

###############################################################################
# ¹
#   
#   BLAST+dp
#   motif 
###############################################################################
require "MBGD_Conf.pl";
require "libProcList.pl";
require "MBGD_commonUpdate.pl";

###############################################################################
if ($0 eq __FILE__) {
    my($fileNewSeq);
    my($fileout);
    my(@procList);
    my($cmd, $opt);
    my($sta);

    $opt = "-DEBUG='$DEBUG' -nolog";

    # STDERR ˽ϤƤե˽
    &openLogfile($main::logfile);

    # оݤ󤬵Ҥ줿ե
    $fileNewSeq  = shift(@ARGV);
    if (! $fileNewSeq) {
        $fileNewSeq = "$ENV{'MBGD_HOME'}/work/newprotseq";
    }
print "f>>$fileNewSeq\n";
    $dbfile = "$DIR_work/blastdb";
    $homOut = "$DIR_work/homology.blastdpres";
    $rpsOut = "$DIR_work/rpsBlastRes";
    $domOut = "$DIR_work/domBlastRes";
    $extractOpt = "-extractdb" if (! $no_extract);
    $checkOpt = "-CHECK_NAMELEN=0" if ($no_checklen);

    #
    @procList = ( { 'title'    => "m0510ExecHomSearch",
                    'procname' => "$DIR_build/m0510ExecHomSearch.pl",
                    'opt'      => "-nolog -deleteTmp -PID='$PID' $extractOpt $checkOpt -OUTNAME=$homOut $dbfile $fileNewSeq" },
                  { 'title'    => "m0540ExecRpsBlast",
                    'procname' => "$DIR_build/m0540ExecRpsBlast.pl",
                    'opt'      => "-nolog $fileNewSeq $rpsOut" },
#                  { 'title'    => "m0550ExecRpsBlastDomTop",
#                    'procname' => "$DIR_build/m0550ExecRpsBlastDomTop.pl",
#                    'opt'      => "-nolog $fileNewSeq $domOut" }
	);

    # ¹
    &doProcList(@procList);


    # θϡMD5 ͤ򥭡˽ԤäƤ롣
    # Web ǤΥӥǤ MD5 ͤǤϤʤ SP:ORF ǥӥɬפ롣
    # DB Ͽ塢MD5 ---> SP:ORF ѴɬפǤ

    exit;
}

###############################################################################
1;#
###############################################################################
