#!/usr/bin/perl -s

use MBGD;
require 'MBGD_Conf.pl';

if (! $TYPE) {
	if ($0 =~ /Homology/i) {
		$TYPE = 'homology';
	} elsif ($0 =~ /ProtMotif/i) {
		$TYPE = 'protmotif';
	}
}
if ($TYPE =~ /homology/i) {
	$Class = "MBGD::Homology";
} elsif ($TYPE =~ /protmotif/i) {
	$Class = "MBGD::ProtMotif";
} elsif ($TYPE =~ /motif/i) {
	$Class = "MBGD::Motif";
}
if ($dbname) {
	$DBI = "dbi:mysql:$dbname";
} elsif ($TYPE =~ /current/i) {
	$DBI = "dbi:mysql:$DBNAME_MBGD";
} elsif ($TYPE =~ /work/i) {
	$DBI = "dbi:mysql:$DBNAME_WORK";
} else {
	$DBI = "dbi:mysql:$DBNAME_ACCUM";
}

@FileNames = @ARGV;

if (! $Class || ! @FileNames) {
	die "Usage: $0 [-dbname=DBNAME] -TYPE=[DBTYPE.]TABLENAME FILENAME\n";
}

print STDERR "Loading data for $Class on $DBI\n";

$db = MBGD::DB->new($DBI);
if ($delete){
	$tablename = MBGD::Schema::get_schema_classname($Class);
	$db->drop_tables($tablename);
}
$tab = $db->get_table($Class, {mode=>'write', create=>1});
if ($ignore) {
	$loadopt->{ignore} = 1;
}
if (! $prio) {
	$loadopt->{prio} = 'low_priority';
}

foreach $filename (@FileNames) {
    next if (! -e $filename);
	if ($BLKSIZ) {
		&loadfile_blk($tab, $filename, $BLKSIZ, $SKIP);
	} else {
		$tab->load_from_file($filename, $loadopt);
	}
}
print STDERR "Done; flushing the table ...\n";
$tab->flush;
print STDERR "Done\n";

sub loadfile_blk {
	my($tab, $filename, $blksiz, $skipblk) = @_;
	my($cnt, $totcnt);
	my($tmpout)= "/tmp/tmp_load_mbgddata.$$";
	open(F, $filename) || die;
	open(O, ">$tmpout") || die;
	while(<F>){
		next if (++$totcnt <= $skipblk);
		print O $_;
		if (++$cnt >= $blksiz) {
			close(O);
			$tab->load_from_file($tmpout, $loadopt);
			open(O, ">$tmpout") || die;
print STDERR "Load...Done: $totcnt\n";
			$cnt = 0;
		}
	}
	close(F);
	if ($cnt) {
		close(O);
		$tab->load_from_file($tmpout, $loadopt);
print STDERR "Load...Done: $totcnt\n";
	}
}
