#!/usr/bin/perl -s
use strict;
use MBGD::DB;

###############################################################################
# $BA0Ds>r7o!'(B$HOME/.my.cnf $B$G(B user/password $B$r@_Dj$7$F$"$k$3$H(B
sub showTableStatus {
    my($dbname) = shift;
    my($ref) = {};
    my($cmd);

    my($sql) = "show table status;";
    my($cmd) = "$main::CMD_mysql -D '$dbname' -e '$sql'";

    print STDERR "EXEC :: $cmd\n" if ($main::DEBUG);
    my(@resLst) = `$cmd`;
    my(@keyLst) = split(/\s+/, uc(shift(@resLst)));

    foreach my$res (@resLst) {
        my(@valLst) = split(/\s+/, $res);
        my($ent) = {};
        foreach my$k (@keyLst) {
            $ent->{"$k"} = shift(@valLst);
            $ent->{"$k"} .= " " . shift(@valLst) if ($k =~ /_time$/i);
        }

        my($name) = $ent->{'NAME'};
        $ref->{"$name"} = $ent;
    }

    return $ref;
}

###############################################################################
#
sub printTabSta {
    my($ref) = shift;
    my(@keyList) = ('NAME', 'ROWS', 'DATA_LENGTH', 'UPDATE_TIME');

    #
    foreach my$key (@keyList) {
        print $key, "\t";
    }
    print "\n";

    foreach my$name (sort(keys(%{$ref}))) {
        my($ent) = $ref->{"$name"};
        foreach my$key (@keyList) {
            print $ent->{"$key"}, "\t";
        }
        print "\n";
    }
    print "//\n";
}

###############################################################################
#
sub printGenomeSta {
    my($dbname) = shift;

    #
    my($db) = new MBGD::DB($dbname);
    my($tab) = 'project';
    my($opt);
    my($refRes);
    my($ref);

    # $B99?7@8J*<o?t(B
    $opt = {};
    $opt->{'columns'} = "max(mbgd_update) as last_upd"; # $BA02s$N99?7F|(B
    $refRes = $db->select_fetch($tab, $opt);
    ($ref) = @{$refRes->{'INFO'}};
    my($lastUpd) = $ref->{'last_upd'};

    $opt = {};
    $opt->{'columns'} = "count(*) as n";
    $opt->{'where'} = "mbgd_update is not null and udate > '$lastUpd'";
    $refRes = $db->select_fetch($tab, $opt);
    ($ref) = @{$refRes->{'INFO'}};
    print 'mod_genomes', "\t", $ref->{'n'}, "\n";

    # $B?75,DI2C@8J*<o?t(B
    $opt = {};
    $opt->{'columns'} = "count(*) as n";
    $opt->{'where'} = "mbgd_update is null";
    $refRes = $db->select_fetch($tab, $opt);
    ($ref) = @{$refRes->{'INFO'}};

    print 'new_genomes', "\t", $ref->{'n'}, "\n";

    print "//\n";
}

###############################################################################
if ($0 eq __FILE__) {

    if ($main::logdir) {
        my($sec, $min, $hour, $mday, $mon, $year) = localtime(time());
        $year += 1900;
        $mon++;
        my($file) = sprintf("$main::logdir/mbgd%04d%02d%02d", $year, $mon, $mday);
        open(FH, ">$file");
        select(FH);
        $| = 1;
    }

    foreach my$dbname (@ARGV) {
        printTabSta(showTableStatus($dbname));
        printGenomeSta($dbname);
    }
}

###############################################################################
1;#
###############################################################################
