#!/bin/bash

if [ "$RECOG_HOME" == "" ]; then
    echo 'ERROR :: Can not found environment variable RECOG_HOME.'
    exit -1
fi
export MBGD_HOME=$RECOG_HOME

###############################################################################
export PERL5LIB=${RECOG_HOME}/perllib:${MBGD_HOME}/perllib
cd $MBGD_HOME/build

readonly CMD_MYSQL=`./print_def.pl CMD_mysql`
readonly DBNAME_MBGD=`./print_def.pl DBNAME_MBGD`
readonly DBNAME_ACCUM=`./print_def.pl DBNAME_ACCUM`
readonly DBNAME_WORK=`./print_def.pl DBNAME_WORK`
readonly DBNAME_TMP=`./print_def.pl DBNAME_TMP`
readonly DBNAME_TMP2=`./print_def.pl DBNAME_TMP2`
readonly DBNAME_RECOG=`./print_def.pl DBNAME_RECOG`
readonly DBNAME_RECOGWK=`./print_def.pl DBNAME_RECOGWK`
readonly DBNAME_FUNC=`./print_def.pl DBNAME_FUNC`
readonly DBNAME_FUNCWK=`./print_def.pl DBNAME_FUNCWK`

: <<'#__COMMENT_OUT__'
echo "DBG :: DBNAME_MBGD    $DBNAME_MBGD"
echo "DBG :: DBNAME_ACCUM   $DBNAME_ACCUM"
echo "DBG :: DBNAME_WORK    $DBNAME_WORK"
echo "DBG :: DBNAME_TMP     $DBNAME_TMP"
echo "DBG :: DBNAME_TMP2    $DBNAME_TMP2"
echo "DBG :: DBNAME_RECOG   $DBNAME_RECOG"
echo "DBG :: DBNAME_RECOGWK $DBNAME_RECOGWK"
echo "DBG :: DBNAME_FUNC    $DBNAME_FUNC"
echo "DBG :: DBNAME_FUNCWK  $DBNAME_FUNCWK"
#__COMMENT_OUT__


#
echo "create databases"
#

#: <<'#__COMMENT_OUT__'

#
date >> $RECOG_HOME/build/build.log

#
echo "create database '$DBNAME_MBGD'"
./createDatabase.pl $DBNAME_MBGD >>$RECOG_HOME/build/build.log 2>&1
if test $? -ne 0 ; then
    echo "Can not create database $DBNAME_MBGD"
    exit -1
fi
echo "create tables for '$DBNAME_MBGD'"
echo "$CMD_MYSQL -D $DBNAME_MBGD -e '\. mysql/create_tables.sql'"
#$CMD_MYSQL -D $DBNAME_MBGD -e '\. mysql/create_tables.sql'
$RECOG_HOME/bin/mysql_recog.sh -D $DBNAME_MBGD < mysql/create_tables.sql

#
echo "create database '$DBNAME_ACCUM'"
./createDatabase.pl -NO_TABLES $DBNAME_ACCUM >>$RECOG_HOME/build/build.log 2>&1
if test $? -ne 0 ; then
    echo "Can not create database $DBNAME_ACCUM"
    exit -1
fi
echo "create tables for '$DBNAME_ACCUM'"
#$CMD_MYSQL -D $DBNAME_ACCUM -e '\. mysql/create_tables_accum.sql'
$RECOG_HOME/bin/mysql_recog.sh -D $DBNAME_ACCUM < mysql/create_tables_accum.sql

#
echo "create database '$DBNAME_WORK'"
./createDatabase.pl $DBNAME_WORK >>$RECOG_HOME/build/build.log 2>&1
if test $? -ne 0 ; then
    echo "Can not create database $DBNAME_WORK"
    exit -1
fi
echo "create tables for '$DBNAME_WORK'"
#$CMD_MYSQL -D $DBNAME_WORK  -e '\. mysql/create_tables.sql'
$RECOG_HOME/bin/mysql_recog.sh -D $DBNAME_WORK < mysql/create_tables.sql

#
echo "create database '$DBNAME_TMP'"
./createDatabase.pl -NO_TABLES $DBNAME_TMP >>$RECOG_HOME/build/build.log 2>&1
if test $? -ne 0 ; then
    echo "Can not create database $DBNAME_TMP"
    exit -1
fi

#
echo "create database '$DBNAME_TMP2'"
./createDatabase.pl -NO_TABLES $DBNAME_TMP2 >>$RECOG_HOME/build/build.log 2>&1
if test $? -ne 0 ; then
    echo "Can not create database $DBNAME_TMP2"
    exit -1
fi

#
echo "create database '$DBNAME_RECOG'"
./createDatabase.pl -NO_TABLES $DBNAME_RECOG >>$RECOG_HOME/build/build.log 2>&1
if test $? -ne 0 ; then
    echo "Can not create database $DBNAME_RECOG"
    exit -1
fi
#$CMD_MYSQL -D $DBNAME_RECOG  -e '\. mysql/create_tables_recog.sql'
$RECOG_HOME/bin/mysql_recog.sh -D $DBNAME_RECOG < mysql/create_tables_recog.sql

#
echo "create database '$DBNAME_RECOGWK'"
./createDatabase.pl -NO_TABLES $DBNAME_RECOGWK >>$RECOG_HOME/build/build.log 2>&1
if test $? -ne 0 ; then
    echo "Can not create database $DBNAME_RECOGWK"
    exit -1
fi
#$CMD_MYSQL -D $DBNAME_RECOGWK  -e '\. mysql/create_tables_recog.sql'
$RECOG_HOME/bin/mysql_recog.sh -D $DBNAME_RECOGWK < mysql/create_tables_recog.sql

#
echo "create database '$DBNAME_FUNC'"
./createDatabase.pl -NO_TABLES $DBNAME_FUNC >>$RECOG_HOME/build/build.log 2>&1
if test $? -ne 0 ; then
    echo "Can not create database $DBNAME_FUNC"
    exit -1
fi

#
echo "create database '$DBNAME_FUNCWK'"
./createDatabase.pl -NO_TABLES $DBNAME_FUNCWK >>$RECOG_HOME/build/build.log 2>&1
if test $? -ne 0 ; then
    echo "Can not create database $DBNAME_FUNCWK"
    exit -1
fi

#__COMMENT_OUT__

#
