#!/usr/bin/perl -s

###############################################################################
#
# Usage :: $0 [-prosite=file-path] [-motif=cdd-dir]
#
###############################################################################
use DirHandle;
use FileHandle;
use MBGD;
require "MBGD_Conf.pl";

###############################################################################
#
sub storeMotif {
    my($db, $store_opt, $motlib, $motid, $motname, $descr) = @_;
    my($info);
    my($infoMotif);

    $info = {};
    $info->{'motlib'}  = $motlib;
    $info->{'motid'}   = $motid;
    $info->{'motname'} = $motname;
    $info->{'descr'}   = $descr;

    $infoMotif = MBGD::Motif->new($info);
    $infoMotif->store($db, $store_opt);
#    print join("\t", $motlib, $motid, $motname, $descr), "\n";

    return;
}

###############################################################################
#
sub parseProsite {
    my($file) = @_;
    my($fh);
    my($type);
    my($motlib, $motid, $motname, $descr);
    my($dbname);
    my($db);
    my($store_opt);

    $motlib = "prosite";

    if ($main::DEBUG) {
        $dbname = $main::MYSQL_DBTEST;
    }
    else {
        $dbname = $main::MYSQL_DBACCUM;
    }
    $db = MBGD::DB->new($dbname);
    $store_opt = {};

    $fh = new FileHandle("$file") || die("Can not open $file($!)");
    while(<$fh>) {
        chomp();

        if (m#^//#) {
            if ($type =~ /PATTERN/) {
                &storeMotif($db, $store_opt, $motlib, $motid, $motname, $descr);
            }
        }
        elsif (/^ID\s+(\S+);\s+(\S+)\./) {
            $motname = $1;
            $type = $2;
        }
        elsif (/^AC\s+(PS\d+)/) {
            $motid = $1;
        }
        elsif (/^DE\s+(.+)$/) {
            $descr = $1;
        }

    }
    $fh->close();

    return;
}

###############################################################################
# /bio/db/rpsblast/cdd ǥ쥯ȥˤ *.csq եΥȥԤ
# 
sub parseMotif {
    my($basedir) = @_;
    my($dbname);
    my($db);
    my($store_opt);
    my($dh);
    my($fh);

    if ($main::DEBUG) {
        $dbname = $main::MYSQL_DBTEST;
    }
    else {
        $dbname = $main::MYSQL_DBACCUM;
    }
    $db = MBGD::DB->new($dbname);
    $store_opt = {};

    $dh = new DirHandle("$basedir") || die("Can not open $basedir($!)");
    foreach $file ($dh->read()) {
        next if ($file !~ /\.csq$/);

        $filename = "$basedir/$file";
        $fh = new FileHandle("$filename") || die("Can not open $filename($!)");
        while(<$fh>) {
            if (/^>\w+\|(\w+)\|(\S+)\s+([^,]+)(,.+)$/) {
                $motlib  = $1;
                $motid   = $2;
                $motname = $3;
                $descr   = $3 . $4;
                &storeMotif($db, $store_opt, $motlib, $motid, $motname, $descr);
                last;
            }
        }
        $fh->close();
    }
    undef($dh);

    return;
}

###############################################################################
if ($0 eq __FILE__) {

    &parseProsite($main::prosite) if ($main::prosite);

    &parseMotif($main::motif)     if ($main::motif);

    exit;
}

###############################################################################
1;#
###############################################################################
