#!/usr/bin/perl -s
use strict;
use MBGD::Taxonomy;
use RecogProjectCommon;
use RECOG::RecogProject;

###############################################################################
sub print_usage {
    print STDERR "Usage :: $0 [-RANK='rank'] [-MATCH='match condition'] [-PROJECT=proj_id] [spec1 spec2 ... specN] \n";
    print STDERR "    -RANK :: default='genus'\n";
    print STDERR "\n";
    print STDERR "\n";
    print STDERR "e.g. :: $0 -RANK='phylum' -MATCH='superkingdom=bacteria|archaea' ape dka smr afu hma\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my(%out_hash);

    my($server_name) = $main::URL_PUBLIC;

    #
    my(@spec_args) = @ARGV;
    if (0 < $main::PROJECT) {
        my($recog_proj_ref) = RECOG::RecogProject->new();
        my($proj_ref) = $recog_proj_ref->get_project('', $main::PROJECT);
        @spec_args = ();
        if (exists($proj_ref->{'PROP'}->{'spid_list'})) {
            my($file_genome) = "$ENV{'MBGD_HOME'}/etc/'
                             . $main::NAME_PUBLIC_SERVER
                             . '/tab_genome.txt";
            my($tab_genome_pub_ref) = RecogProjectCommon::read_tab_genome($file_genome);
            my($tab_genome_loc_ref) = RecogProjectCommon::read_tab_genome_local();
            my(@spid_list) = @{$proj_ref->{'PROP'}->{'spid_list'}};
            foreach my$spid (@spid_list) {
                my($ent) = $tab_genome_pub_ref->{'SPID'}->{"$spid"};
                if (!$ent) {
                    $ent = $tab_genome_loc_ref->{'SPID'}->{"$spid"};
                }
                if (!$ent) {
                    next;
                }
                push(@spec_args, $ent->{'sp'});
            }
        }
    }

    #
    my($delim) = ',';
    if ($main::DELIM) {
        $delim = $main::DELIM;
    }

    #
    my($rank) = 'genus';
    if ($main::RANK) {
        $rank = $main::RANK;
    }

    #
    my($matchRank, $matchName) = split(/=/, $main::MATCH);

    #
    my($dir_tax) = "$ENV{'MBGD_HOME'}/database.work";
    my($tax) = MBGD::Taxonomy->new($dir_tax);

    #
    my($file_tab_genome) = "$ENV{'RECOG_HOME'}/etc/'
                         . $main::NAME_PUBLIC_SERVER
                         . '/tab_genome.txt";
#    $tax->clear_specweight();
    $tax->read_specweight($file_tab_genome);

    #
    my($opt) = {};
    $opt->{'one_strain'}        = $rank;
    $opt->{'match_rank'}        = $matchRank;
    $opt->{'match_name_regexp'} = $matchName;
    $opt->{'exists_species'}    = {};
    foreach my$spec (@spec_args) {
        $opt->{'exist_sp'}->{"$spec"} = 1;
    }
    my(@spec_list) = $tax->get_species($opt);
    foreach my$spec (@spec_list) {
        $out_hash{"$spec"} = 1;
    }

    #
    my($tab_genome_local_ref) = RecogProjectCommon::read_tab_genome_local();
    foreach my$spec (@ARGV) {
        my($ref) = $tab_genome_local_ref->{'SPEC'}->{"$spec"};
        if (!$ref) {
            next;
        }
        my($spid) = $ref->{'spid'};
        if ($spid =~ /^gu\d+$/i) {
            $out_hash{"$spec"} = 1;
        }
    }
    print join($delim, keys(%out_hash)) , "\n";
}

###############################################################################
1;#
###############################################################################
