#ifndef _CLUSTER_INFO_H_
#define _CLUSTER_INFO_H_
#include "Tree.h"
#include "ClusterNode.h"

class ClusterInfo {
	string upper_name;
	string name;
	int clustid;
	int size;
	DistTreeList treeList;
public:
	ClusterInfo(list<DistTree*>* treeList, int clustid=0);
	int getSize() { if (size==0){cerr <<"Warn:clsize==0\n";} return size;}
	int getClustID() {return clustid;}
	int getTreeNum() {return treeList.getTreeNum();}
	string getUpperName() {return upper_name;}
	string getName() {return name;}
	DistTreeList* getTreeList() {return &treeList;}
	void setDomInfo(DomInfo *domInfo);
	bool checkClustID(string start_clustid, string start_clType="");
	friend ostream& operator<<(ostream&, const ClusterInfo&);
};

class AllClustersInfo {
	vector<ClusterInfo> clusterInfo;
	map<int, int> clusterInfo_clustID_Map;
	map<string, HomClusterData> homClusterInfo;
	DomInfo domInfo;
public:
	static AllClustersInfo *readClusters(ReadTree *rtree, string startOpt="");
	DomInfo *getDomInfo() {return &domInfo;}
	int getSize() { return clusterInfo.size(); }
	ClusterInfo* getClusterInfoByID(int clustid);
	ClusterInfo* getClusterInfo(int idx);
	int getClustID(int idx);
	HomClusterData* getHomClusterInfo(string homclname);
	DistTreeList* getClusterTreeList(int idx);
};

#endif
