#include <iostream>
#include "ClusterNode.h"
#include "PairDist.h"
using namespace std;

MemAlloc<PairDist> PairDist::objPool(50000);

PairDist *PairDist::create(ClusterNode *_node1, ClusterNode *_node2,
		double _dist, double _score) {
	PairDist *pdist = objPool.allocate();
/*
if (objPool.allocSize() % 1000 == 0) {
cout << "Alloc: " << objPool.allocSize() << endl;
}
*/
	pdist->initialize(_node1, _node2, _dist, _score);
	return pdist;
}
PairDist *PairDist::create(HomData *hd) {
	PairDist *pdist = objPool.allocate();
/*
if (objPool.allocSize() % 1000 == 0) {
cout << "Alloc: " << objPool.allocSize() << endl;
}
*/
	ClusterNode *n1 = ClusterNode::createLeafNode(hd->dom1);
	ClusterNode *n2 = ClusterNode::createLeafNode(hd->dom2);
	pdist->initialize(n1, n2, hd->pam, hd->score);
	return pdist;
}

ClusterNode *PairDist::mergeNodes() {
	ClusterNode *cnode = ClusterNode::createIntNode(this);
	return cnode;
}
/*
PairDist::PairDist(ClusterNode *_node1, ClusterNode *_node2,
		double _dist, double _score) {
	initialize(_node1, _node2, _dist, _score);
}
PairDist::PairDist(HomData *hd) {
	ClusterNode *n1 = ClusterNode::createLeafNode(hd->dom1);
	ClusterNode *n2 = ClusterNode::createLeafNode(hd->dom2);
	initialize(n1, n2, hd->pam, hd->score);
}
**/
void PairDist::declRef() {
//cout << "decl<<" << refcount << endl;
	if (--refcount <= 0) {
		objPool.freeData(this);
	}
}
void PairDist::initialize(ClusterNode *_node1, ClusterNode *_node2,
			double _dist, double _score) {
	node1 = _node1; node2 = _node2;
	deleted=false;
//	dist = _dist; score = _score;
	setScores(_dist, _score);
	id = totalNum++;
	count = 1;
	refcount = 3;
}
void PairDist::reset() {
	objPool.deleteAll();
	totalNum = 0;
}
int PairDist::getCount() const {
	return(count);
}

void PairDist::print(ostream& ost) {
	ost << node1->getName() << " " << node2->getName() <<
		" " << node1->getDomain()->getFrom() <<
		" " << node1->getDomain()->getTo() <<
		" " << node2->getDomain()->getFrom() <<
		" " << node2->getDomain()->getTo() <<
		" " << getDist() << " " << getScore() << endl;
}

ostream& operator<<(ostream& ost, const PairDist& pd) {
	return( ost << *(pd.node1) << " " << *(pd.node2) <<
		" " << pd.node1->getDomain()->getFrom() <<
		" " << pd.node1->getDomain()->getTo() <<
		" " << pd.node2->getDomain()->getFrom() <<
		" " << pd.node2->getDomain()->getTo() <<
		" " << pd.getDist() << " " << pd.getScore()
		<< "<" <<pd.getID()<<">");
}
SimValue::ReprValue SimValue::reprValue = SCORE;
SimValue::Best SimValue::best = MAX;
int PairDist::totalNum;
