#ifndef _SPECSET_H_
#include <iostream>
#include <bitset>
#include <vector>
#include <map>
#include <set>
#define _SPECSET_H_
#define MAX_SPNUM 5000
using namespace std;

class SpecSet {
	bitset<MAX_SPNUM> specSet;
	static int spnum;
	static map<string, int> specIdx;
	static string species[MAX_SPNUM];
	static double SPweight[MAX_SPNUM];
public:
	SpecSet() {
	}
	static int getSPid(string spec);
	static void addNewSpecies(string& spec);
	static bool checkSpecies(const string& spec);
//	static void setSPid(int id);
	static int getSPnum() { return spnum; }
	static string getSPname(int id) { return species[id]; }
	static double getSPweight(int id) { return SPweight[id]; }
	static void setSPweight(int id, double weight);

	void copySpecSet(SpecSet& spSet);
	void setSpecSet(SpecSet* spSet);
	void setSpecSet(set<string>* spSet);
	void setSpecSet(string spec);
	void setSpecSet(int spid);
	void clearSpSet() { specSet.reset(); }
	void printSpSet(ostream& ost=cout) const;
	bool getSpFlag(string spname);
	bool getSpFlag(int spid);
	int count() const {
		return specSet.count();
	}
	string toString();
	void flip();

	friend void specFlagCOMPL(const SpecSet& spset1, SpecSet& newSpSet);
	friend void specFlagOR(const SpecSet& spset1, const SpecSet& spset2, SpecSet& newSpSet);
	friend void specFlagAND(const SpecSet& spset1, const SpecSet& spset2, SpecSet& newSpSet);
	friend void specFlagANDNOT(const SpecSet& spset1, const SpecSet& spset2, SpecSet& newSpSet);

	friend int specFlagORcnt(const SpecSet& spset1, const SpecSet& spset2);
	friend int specFlagANDcnt(const SpecSet& spset1, const SpecSet& spset2);
	friend bool specFlagInclude(const SpecSet& spset1, const SpecSet& spset2);
	friend int specFlagMaskCheck(const SpecSet& spset1, const SpecSet& spset2);
	friend ostream& operator<<(ostream&, const SpecSet&);
};
#endif
