#include <iostream>
#include <map>
#include <vector>
#include <stdio.h>
#include "Tree.h"
#include "SpecTree.h"
#include "SpecSet.h"
#include "SpecSetInstances.h"
#include "ClusterNode.h"
#include "ClusterInfo.h"
#include "PairDist.h"

struct TaxNodeData {
	SpecSet spFlag_cmpr;
	ClusterNode *genenode;
	int taxnode_size();
	double taxnode_score();
	void copyData(TaxNodeData *data2);
	TaxNodeData();
};
struct TaxMapOutBuf {
	ClusterNode *cnode;
	int domn;
	TaxNodeData taxNode1;
	TaxNodeData taxNode2;
	char flag;
	string getKeyName();
	double taxinfo_score();
	bool better_taxinfo_score(double score);
};
class TaxonomyMapping {
	vector<TaxMapOutBuf> taxMapOutData;
	typedef vector<TaxNodeData> TaxNodeStack;
	TaxNodeStack taxNodes;
//	ClusterNode *root;
	FILE *outFp;
	SpecSetInstances* specSetInst;
	SpecTree* specTree;
	int spnode_idx, prev_spnode_idx;
	double bestRatio;
	MemAlloc<ClusterNode> clustNodePool;
public:
	TaxonomyMapping(SpecTree* spTree, SpecSetInstances* spSetInst, double bestRatio=0.0, FILE *ofp = stdout);
	void mapTaxInfo_output(string clutname);
	void mapTaxInfo_Cinfo(list<ClusterNode*> *cinfo);
	void mapTaxInfo(ClusterNode *cnode);
	void mapTaxInfo_sub(ClusterNode *cnode);
	void saveTaxMap(ClusterNode *cnode);
	void saveTaxMap_sub(ClusterNode *cnode);
	void taxnode_output(TaxNodeData *taxNode, SpecSet *selfSet);
	void outputTaxInfo(TaxMapOutBuf* taxInfo);

};
