#!/usr/bin/perl -s
use strict;
use IO::Dir;
use IO::File;

###############################################################################
#
sub parse_cdd_smp {
}

###############################################################################
#
sub title_cdd_smp {
    my($file_cdd_smp) = shift;

    my($sta_found_title) = 0;
    my($ref);
    my($fh) = IO::File->new("$file_cdd_smp") || return;
    while (my$line=$fh->getline()) {
        $line =~ s#[\r\n]*$##;

        if ($line =~ /^\s+length\s+(\d+)/) {
            $ref->{'length'} = $1;
            if ($ref->{'title'} ne '') {
                last;
            }
        }
        elsif ($line =~ /^\s+title\s+(.+)/) {
            $ref->{'title'} = $1;
            $sta_found_title = 1;
        }
        elsif ($sta_found_title) {
            if ($line =~ /^\s+\}/) {
                $ref->{'title'} =~ s#^\s*\"##;;
                $ref->{'title'} =~ s#\"\s*$##;;
                $sta_found_title = 0;
                if ($ref->{'length'} ne '') {
                    last;
                }
            }
            $ref->{'title'} .= $line;
        }

    }
    $fh->close();

    return $ref;
}

###############################################################################
#
sub conv_cdd2motif {
    my($dir) = shift;

    my($program) = 'rpsblast';
    my($dh) = IO::Dir->new("$dir") || return;
    while (my$file=$dh->read()) {
        next if ($file !~ /^([a-z]+).*\.smp$/i);

        my($motlib) = ucfirst(lc($1));
        my($ref) = title_cdd_smp("$dir/$file");
        my($motid, $motname, $descr) = split(/,/, $ref->{'title'});
        my($len) = $ref->{'length'};

        print join("\t", $motlib, $motid, $motname, $program, $len, $descr), "\n";
    }
    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dir) = "$ENV{'MBGD_HOME'}/database.work/cdd";
    if ($main::DIR) {
        $dir = $main::DIR;
    }

    conv_cdd2motif($dir);
}

###############################################################################
1;#
###############################################################################
