#!/usr/bin/perl -s
package DomClust::WithCache;
###############################################################################
# ̾
#     DomClust::WithCache.pm
#
# 
#     ץdomclust¹Ԥ̤ɸϤ˽Ϥ롣
#
# 
#     ܥ⥸塼 DomClust 쥯饹ȤƤꡢdomclust¹Է̤ե
#     (⤷DBMS)˥å夹뤳Ȥǡ쥹ݥ󥹻֤ṳ̂ޤ
#     ΤǤ롣
#     
# ѿ
#     'Cache'           Cache⥸塼Υ󥹥󥹤ݻ
#     'CommandStr'      domclust¹ԥơȥȤݻ
#
# ᥽åɰ
#     new()
#     _init()
#     exec()
#     isOnCache()
#     editCacheName()
#     editCacheRead()
#
# 
#
###############################################################################
use strict;
our(@ISA);                                   # require 5.6.0;
use FileHandle;

use DomClust;
use Cache;

@ISA = ( "DomClust" );    # require 5.6.0;

# ѥåѿ
use constant CachePrefix => "domclust_cache"; # å(ǥå)Υץե

use constant CacheModule => "Cache";          # åԤ⥸塼̾

###############################################################################
# ̾
#     new()
# 
#     󥹥ȥ饯
# 
#     $that  : 饹̾(⤷ϥ󥹥󥹤Υե)
#     @args  : domclustưץ(᥽åsetOption()򻲾)
# 
#     󥹥󥹤ؤΥե
# 
#
# 
#
sub new {
    my $that = shift;
    my @args = @_;

    # $that ե󥹤ʤ顢ѥå̾롣
    my $class = ref($that) || $that;

    my $self = {};

    bless($self, $class);
    $self->_init(@args);

    return $self;
}

###############################################################################
# ̾
#     _init()
# 
#     
# 
#     $self  : 󥹥󥹤ؤΥե
#     %param : ưץݻϥå
# 
#     ʤ
# 
#     ưѥ᡼Υǥեͤѿ¸롣
# 
#
sub _init {
    my $self  = shift;
    my %param = @_;

    # ʲ˽
    $self->SUPER::_init(%param);

    $self->{'Cache'} = new Cache('driver' => $param{'driver'},
				 'space'  => $param{'space'},
				 'prefix' => CachePrefix);
}

###############################################################################
# ̾
#     DESTROY()
# 
#     ǥȥ饯
# 
#     $self : 󥹥󥹤Υե
# 
#     ʤ
# 
#
# 
#     ̾ѿλѤեϥɥλѤξϥǥȥ饯Ѱ
#     ʤƤŬڤ˴롣
#     եʤɤ롣
#
#sub DESTROY {
#    my $self = shift;
#
#    # ȤΥ饹˴³
#    # ѡ饹Υ󥹥ѿѤƤʤϡ
#    # ѡ饹 DESTROY() ƤӽФθǤ褤
#
#    # ǥȥ饯Ͽƥ饹ʤƤ줿褤
#    $self->SUPER::DESTROY;
#}


###############################################################################
# ̾
#     exec()
# 
#     domclustư롣
# 
#     $self : 󥹥󥹤Υե
#     $cmnd : domclust¹ԥơȥ(ץ)
# 
#     ʤ
# 
#     domclustưϥեϥɥ˥ѥפǷ礹롣
# 
#
sub exec {
    my $self = shift;
    my $cmnd = shift;
    my $name;           # å̤̾

    unless(defined $cmnd) {
	$cmnd = $self->editStatement();
	$name = $self->editCacheName();
    }
    else {
	# 饳ޥʸ󤬻ꤵƤϡ
	# 򥭥å̾ȤѤ롣
	$name = $cmnd;
    }
    $self->{'CommandStr'} = $cmnd;
    my $fh;
    my $id;

    my $cfh = $self->{'Cache'};
    
    # åο
    if($id = $cfh->create($name)) {
	# ץ¹Ԥ̤ե˽Ϥ롣
	$self->SUPER::exec($name);
	while(my $line = $self->getEachLine()) {
	    $cfh->write($line);
	}
	$cfh->close;
    }
    # Ʊ̾Υå夬¸ߤ
    elsif($id = $cfh->exists($name)) {
	# NOP
    }
    else {
	# åեκե̾μˤ⼺
	die "*error* cache file not found : name[$name]\n";
    }
    my $cfname = $cfh->getCacheFname('id' => $id);
    my $stream = sprintf("%s |", $self->editCacheRead($cfname));
    $fh = new FileHandle($stream) || die "exec failure($!): $stream\n";

    # ϥե̾ꤵƤϡΥե˼¹Է̤Ϥ롣
    if(defined $self->{'OutFile'}) {
	my $ofh = new FileHandle("> " . $self->{'OutFile'}) ||
	    die sprintf("open failure(%s) : %s\n", $!, $self->{'OutFile'});
	while(my $line = $fh->getline) {
	    print $ofh $line;
	}
	$ofh->close;
    }
    else {
	# ϥե̾ꤵƤʤ硢¹ԥץѥפǷ礷
	# եϥɥݻ롣
	$self->{'FileHandle'} = $fh;
    }

    return;
}

###############################################################################
# ̾
#     isOnCache()
# 
#     ꤷơȥȤμ¹Է̤å˻ĤäƤ뤫Ĵ٤롣
# 
#     $self : 󥹥󥹤Υե
#     $cmnd : domclust¹ԥơȥ(ץ)
# 
#     1 : 㥷˻ĤäƤ롣
#     0 : 㥷˻ĤäƤʤ
# 
#     
# 
#
sub isOnCache {
    my $self = shift;
    my $cmnd = shift;
    my $rc = 0;

    $cmnd = $self->editCacheName() unless(defined $cmnd);

    if($self->{'Cache'}) {
	my $cobj = $self->{'Cache'};
	my $id = $cobj->exists($cmnd);
	$rc = 1 if(defined $id);
    }

    return $rc;
}

###############################################################################
# ̾
#     editCacheName()
# 
#     åե̤̾Τ롣
#     Ȥꡢå夹ǡ(ַ)륹ơȥԽ
#       ʤΤǡ̾ɤ⤷ʤ
# 
#     $self : 󥹥󥹤Υե
# 
#     å̾(domclust¹ԥơȥ)
# 
#     
# 
#
#
sub editCacheName {
    my $self = shift;

    # DomClust¹Ԥ뤿Υޥɥ饤󡦥ơȥȤ롣
    my $cmnd = $self->{'ProgramFileName'};
    foreach my $opt (sort keys %{$self->{'Option'}}) {
	next if($opt eq '-n'  || $opt eq '-ne' || $opt eq '-p'  || $opt eq '-H' ||
		$opt eq '-ai' || $opt eq '-ao' || $opt eq '-t'  || $opt eq '-o' ||
		$opt eq '-R'  || $opt eq '-O');  # 줬
#		$opt eq '-R');
#		$opt eq '-R'  || $opt eq '-v');

	$cmnd .= sprintf(" %s%s",$opt, $self->{'Option'}{$opt});
    }
    $cmnd .= " -o10"; # ٷ̤פ
    $cmnd .= sprintf(" %s %s",
		     $self->{'SimFile'},
		     $self->{'GeneFile'});
}

###############################################################################
# ̾
#     editCacheRead()
# 
#     å˥פե򸵤domclustƼ¹Ԥ뤿
#     ơȥȤԽ롣
#
# 
#     $self : 󥹥󥹤Υե
# 
#     ץեѤdomclust¹ԥơȥ
# 
#     
# 
#
sub editCacheRead {
    my $self = shift;
    my $dump = shift;

    my $cmnd = $self->{'ProgramFileName'};
    foreach my $opt (sort keys %{$self->{'Option'}}) {
	next if($opt eq '-R' || $opt eq '-v');
	$cmnd .= sprintf(" %s%s", $opt, $self->{'Option'}{$opt});
    }
    $cmnd .= sprintf(" -R%s", $dump);   # פեꤹ
}

###############################################################################
1;#
###############################################################################
