#!/usr/local/bin/perl -s

package MBGD::Homology;

use MBGD::Object;

@ISA = qw{ MBGD::Object };
$MINSPNUM = 10;

sub query_in{
	my($fieldname, $array) = @_;
	qq{$fieldname in ('} .  join("','", @{$array}) . qq{')};
}
sub select {
	my($class, $opt) = @_;
	$class->select_orig($opt);
##	$class->select_accum($opt);
}
sub select_accum {
	my($class, $opt) = @_;
	## to be implemented
}
## homology data is no longer included in the open database (only in accum)
sub select_orig {
	my($class, $opt) = @_;
	my($species, $specflag);

	if ($opt->{genes}) {
		my $genes = $opt->{genes};
		if (! ref $genes ) {
			my @genes = split(/,/, $genes);
			$genes = \@genes;
		}
		push(@query, &query_in('spname1', $genes));
		if ($opt->{both}) {
			push(@query, &query_in('spname2', $genes));
		}
	}
	if ($opt->{species}) {
		$species = $opt->{species};
		if (! ref $species ) {
			my @species = split(/,/, $species);
			$species = \@species;
		}
	} elsif ($opt->{genes} && $opt->{both}) {
		my %species;
		foreach $g ($opt->{genes}) {
			($sp,$name) = split(/:/,$g);
			$species{$sp} = 1;
		}
		my @species = keys %species;
		$species = \@species;
	}
	if ($species) {
		if (@{$species} <= $MINSPNUM) {
			push(@query, &query_in('sp1', $species));
			push(@query, &query_in('sp2', $species));
		} else {
			$specflag = 1;
		}
	}

	if ($opt->{score}) {
		push(@query, "score >= $opt->{score}");
	}
	if ($opt->{pam}) {
		push(@query, "pam <= $opt->{pam}");
	}
	if ($opt->{ident}) {
		push(@query, "ident >= $opt->{ident}");
	}
	$query = join(" and ", @query);
	my @result = MBGD::Homology->find($query);
	if ($specflag) {
		my @newres;
		my %spHash;
		foreach $sp (@{$species}) {
			$spHash{$sp} = 1;
		}
		foreach $r (@result) {
			if ($spHash{$r->{sp1}} && $spHash{$r->{sp2}}) {
				push(@newres, $r);
			}
		}
		@result = @newres;
	}
	if ($opt->{with_length}) {
		my(%Hit, %Length);
		foreach $r (@result) {
			$Hit{$r->{spname2}} = 1;
			if ($opt->{both}) {
				$Hit{$r->{spname1}} = 1;
			}
		}
		my @genenames = keys %Hit;
		foreach $g (MBGD::Gene->get(\@genenames)) {
			$Length{"$g->{sp}:$g->{name}"} = $g->{aalen};
		}
		foreach $r (@result) {
			$r->{len2} = $Length{$r->{spname2}};
			if ($opt->{both}) {
				$r->{len1} = $Length{$r->{spname1}};
			}
		}
	}
	@result;
}

package main;
if ($0 eq __FILE__){
	die "$0 genes..\n" if (! $genes);
	$query{genes} = $genes if ($genes);
	$query{species} = $species if ($species);
	$query{both} = $both if ($both);
	$query{score} = $score if ($score);

	@hom = MBGD::Homology->select( \%query );
	foreach $h (@hom) {
		$h->print_tab;
	}
}

1;
