package MBGD_ACCUM::Schema::GenesetChromosome;

use strict;
use warnings;

use base 'DBIx::Class';

__PACKAGE__->load_components(
  "ResultSetManager",
#  "UTF8Columns",
  "InflateColumn::DateTime",
  "Core",
  "Core",
);
__PACKAGE__->table("geneset_chromosome");
__PACKAGE__->add_columns(
  "geneset_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "chromosome_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
);
__PACKAGE__->set_primary_key("geneset_id", "chromosome_id");


# Created by DBIx::Class::Schema::Loader v0.04005 @ 2009-03-19 15:12:50
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:qXXbAYvSF8J1pbt9rzdkhw

__PACKAGE__->belongs_to (
    geneset => 'MBGD_ACCUM::Schema::Geneset', {
        'foreign.id' => 'self.geneset_id'
    }
);
__PACKAGE__->belongs_to (
    chromosome => 'MBGD_ACCUM::Schema::Chromosome', {
        'foreign.id' => 'self.chromosome_id'
    }
);

# You can replace this text with custom content, and it will be preserved on regeneration
1;
