#!/usr/bin/perl -s
package RECOG::DomClust::WithCache;
###############################################################################
# ̾
#     RECOG::DomClust::WithCache.pm
# 
#     ץdomclust¹Ԥ̤ɸϤ˽Ϥ롣
# 
#     ܥ⥸塼 DomClust 쥯饹ȤƤꡢdomclust¹Է̤ե
#     (⤷DBMS)˥å夹뤳Ȥǡ쥹ݥ󥹻֤ṳ̂ޤ
#     ΤǤ롣
#     
# ᥽åɰ
#     new()
#     _init()
#     exec()
#     isOnCache()
#     countClusters()
#     getHeader()
#     getSpecies()
#     getInGroup()
#     getOutGroup()
#     getClusters()
# 
#
###############################################################################
use strict;
our(@ISA);                                   # require 5.6.0;
use FileHandle;
use IO::Socket;
use File::Basename;
use RECOG::DomClust;
use RECOG::Cache;

@ISA = ( "RECOG::DomClust" );    # require 5.6.0;

# ѥåѿ
use constant CachePrefix => "domclust_cache"; # å(ǥå)Υץե

use constant CacheModule => "RECOG::Cache";          # åԤ⥸塼̾

###############################################################################
# ̾
#     new()
# 
#     󥹥ȥ饯
# 
#     $that  : 饹̾(⤷ϥ󥹥󥹤Υե)
#     @args  : domclustưץ(᥽åsetOption()򻲾)
# 
#     󥹥󥹤ؤΥե
# 
#
# 
#

sub new {
    my $that = shift;
    my @args = @_;

    # $that ե󥹤ʤ顢ѥå̾롣
    my $class = ref($that) || $that;
    my $self = {};

    bless($self, $class);
    $self->_init(@args);

    return $self;
}

###############################################################################
# ̾
#     _init()
# 
#     
# 
#     $self  : 󥹥󥹤ؤΥե
#     %param : ưץݻϥå
# 
#     ʤ
# 
#     ưѥ᡼Υǥեͤѿ¸롣
# 
#
sub _init {
    my $self  = shift;
    my %param = @_;

    # ʲ˽
    $self->SUPER::_init(%param);

    $self->{'Cache'} = new RECOG::Cache('driver' => $param{'driver'},
				 'space'  => $param{'space'},
				 'prefix' => CachePrefix);
}

###############################################################################
# ̾
#     DESTROY()
# 
#     ǥȥ饯
# 
#     $self : 󥹥󥹤Υե
# 
#     ʤ
# 
#
# 
#     ̾ѿλѤեϥɥλѤξϥǥȥ饯Ѱ
#     ʤƤŬڤ˴롣
#     եʤɤ롣
#
#sub DESTROY {
#    my $self = shift;
#
#    # ȤΥ饹˴³
#    # ѡ饹Υ󥹥ѿѤƤʤϡ
#    # ѡ饹 DESTROY() ƤӽФθǤ褤
#
#    # ǥȥ饯Ͽƥ饹ʤƤ줿褤
#    $self->SUPER::DESTROY;
#}


###############################################################################
# ̾
#     exec()
# 
#     domclustư롣
# 
#     $self : 󥹥󥹤Υե
#     $cmnd : domclust¹ԥơȥ(ץ)
# 
#     ʤ
# 
#     domclustưϥեϥɥ˥ѥפǷ礹롣
# 
#
sub exec {
    my $self = shift;
	my $db = shift;
    my $cmnd = shift;

	my $res;

    $cmnd = $self->editStatement() unless(defined $cmnd);
    $self->{'CommandStr'} = $cmnd;

    my $fh;
    if($self->{'Cache'}) {
        $fh = $self->{'Cache'};
        my $clusterID = $fh->getTabId($db,$cmnd);
        my $sts = $fh->getStatus($db,$clusterID);
        if($sts < 0) {
            # å夬
            return 1;
        }

        #
        my ($tmpname, $tmpprog, $tmperr) = $self->getTmpfileName($clusterID);

        #
        my($staUseDomclustDump) = $fh->getUseDomclustDump();
        if ($staUseDomclustDump) {
            my($file_dumclust_dump) = $fh->getDumpTabId($db, $cmnd);
            if ($file_dumclust_dump =~ /^\s*$/) {
                $file_dumclust_dump = "$ENV{'MBGD_HOME'}/MBGD.tmp/clustdump_" . $clusterID;
            }
            if (!-e $file_dumclust_dump || -z $file_dumclust_dump) {
                # domclust  dump ̵ ==> dump 
                my($file_dumclust_dump_work) = "$file_dumclust_dump.work.$$";
#                my($cmd) = "$cmnd -o10 2>>$tmpprog 1> $file_dumclust_dump_work";
                my($cmd_dump) = $fh->getCmdForDump($cmnd);
                my($cmd) = "$cmd_dump -o10";
                print STDERR "DBG :: make domclust dump :: $cmd :: " . localtime() . "\n";

                if ($main::USE_QSUB) { # For QSUB
                    my($optQueue) = '-q giga';

                    # sigterm 򤦤ȤνϿ
                    main::setupSigTermFunctionForQsub();

                    # qsub Ǽ¹Ԥ domclust οĽ NFS ͳǼ
                    # 饰ȯ뤿ᡢsocket 𤷤Ƽ롣
                    my($server_ref, $port) = main::create_socket4progress();
                    if (!$server_ref) {
                        print STDERR "ERROR :: Can not create SOCKET\n";
                        die;
                    }

                    #
                    my($fileCmd)    = "$ENV{'MBGD_HOME'}/work/cmd_dom_o10.$$";
                    my($fileLogOut) = "$ENV{'MBGD_HOME'}/work/cmd_dom_o10.out.$$";
                    my($fileLogErr) = "$ENV{'MBGD_HOME'}/work/cmd_dom_o10.err.$$";
                    my($fhCmd) = FileHandle->new(">$fileCmd");
                    if (!$fhCmd) {
                        my($eid) = $DomClustCommon::ERRNO_FILE_ACCESS;
                        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
                        printErrMsgExit($eid, $emsg);
                    }

                    $fhCmd->print("#!/bin/bash\n");
                    $fhCmd->print("#PBS -o $fileLogOut\n");
                    $fhCmd->print("#PBS -e $fileLogErr\n");
                    $fhCmd->print("($cmd > $file_dumclust_dump_work) 2>&1 | $main::CMD_pickup_domclust_progress -HOST=$ENV{'SERVER_ADDR'} -PORT=$port\n");
                    $fhCmd->print("\n");

                    $fhCmd->close();

                    #
                    my($fileJobid) = "$ENV{'MBGD_HOME'}/work/jobid_dom10.$$";
                    my($cmd) = "$main::CMD_qsub $optQueue $fileCmd";
                    print STDERR "DBG :: CMD(domclust dump) :: $cmd\n";
                    system("$cmd > $fileJobid");
                    sleep(3);

                    # JOBID μ
                    my($jobid) = main::getJobidByJobfile($fileJobid);
                    unlink($fileJobid);
                    $DomClustCommon::JOBID_QSUB = $jobid;

                    # socket 𤷤 progress μ
                    my($fh_progress) = FileHandle->new(">>$tmpprog");
                    $fh_progress->autoflush(1);
                    my($sock_ref) = $server_ref->accept();
                    my($client) = $sock_ref->peername();
                    my($client_port, $client_adrs) = unpack_sockaddr_in($client);
                    my($client_hostname) = gethostbyaddr($client_adrs, AF_INET);
                    my($client_ipadrs) = inet_ntoa($client_adrs);

                    while(my$line = $sock_ref->getline()) {
                        $fh_progress->print($line);
                        print STDERR "SOCK :: $line";
                    }
                    $sock_ref->close();
                    $fh_progress->close();


                    # PBS  JOB λޤԤ
                    main::waitDomClustQsub($jobid);
                    $DomClustCommon::JOBID_QSUB = '';

                    unlink($fileLogOut);
                    unlink($fileLogErr);
                    unlink($fileCmd);
                }
                else {
                    # domclust ¹ԡSTDERR ե˥쥯
                    system("$cmd 2>>$tmpprog 1> $file_dumclust_dump_work");
                }

                # dump λ
                rename("$file_dumclust_dump_work", "$file_dumclust_dump");
                unlink("$file_dumclust_dump_work");
            }

            # domclust  dump Ѥdomclust ΤߺƼ¹
            my($cmdDomclust) = ($cmnd =~ /\|\s*(.+)/);
print STDERR "DBG :: USE domclust-dump :: $file_dumclust_dump\n" if ($main::DEBUG);
            $cmdDomclust .= " -R$file_dumclust_dump";

            #
            $res = $self->SUPER::exec($clusterID, $cmdDomclust);
        }
        else {
            $res = $self->SUPER::exec($clusterID, $cmnd);
        }

        #
		$fh->createDCOutfile($db,$clusterID);

		$fh->createDCTreeOutfile($db, $clusterID, "$tmpname.tree");

        my $info = {};     # ǥåե˽ϤԲľ
        my $total = -1;    # 饹 (Ƚǽʾ'-1'Ȥ)
        my $spec = {};     # ʪ̾άΤ򥭡Ȥϥå
        my $igrp = {};     # ingroup ʪ¸
        my $ogrp = {};     # outgroup ʪ¸롣
        my $cgrp;          # ȥ롼פΥݥ
        my $rno = 0;       # ϥ쥳ɿ
        while(my $line = $self->getEachLine()) {
            $rno++;
            $fh->write($line);

            # ϥץ򸫤ơ¸Ф
            if($self->{'Option'}{'-o'} == 5 || $self->{'Option'}{'-o'} == 9) {
                if($line =~ /^\#/) {
                    chomp $line;
                    $line =~ s/\t/ /g;          # '\t' ϶' ' ֤롣
                    $info->{'header'} = $line;
                }
                elsif($line =~ /^(\d+)/) {
                    $total = $1;
                }
            }
            else {
                if($line =~ /^ *Cluster *(\d+)/) {
                    $total = $1;
                    $cgrp  = $igrp;
                }
            }

            if($line =~ /^ *(OutGroup|OuterGroup)/) {
                $cgrp = $ogrp;
            }

            # ʪ̾(ά)롣
            my $dlm = ":";
            $dlm = "_" if($self->{'Option'}{'-o'} == 2 || $self->{'Option'}{'-o'} == 3);
            while($line =~ /(^|[^a-z0-9])([a-z0-9]+)$dlm/gi) {
                $spec->{$2}++;
                $cgrp->{$2}++;
            }
        }

        # ʾ塢å˥쥳ɤϤ
        if($rno > 0) {
            # ǥåեղþ˾򵭺ܤ롣
            $info->{'species'}  = [keys %{$spec}] if(scalar(keys %{$spec}));
            $info->{'ingroup'}  = [keys %{$igrp}] if(scalar(keys %{$igrp}));
            $info->{'outgroup'} = [keys %{$ogrp}] if(scalar(keys %{$ogrp}));
            $info->{'clusters'} = $total;
            $fh->addIndex($info);
            $fh->close;
            $fh->open($clusterID) || $fh->open($cmnd);  ## re-open the cashe file (using clusterID or command string as a key) # <- to be fixed?
        }
        # Ϥʤ
        else {
            $fh->close;
            return 0;
        }
    }
    # domclust¹ԡ
    else {
        $res = $self->SUPER::exec($cmnd);
        $fh = $self->{'FileHandle'};
    }
    $self->{'FileHandle'} = $fh;

    return $res;
}
###############################################################################
# ̾
#     getClusterTableID()
# 
#     ¹Է̤ΥåID֤
# 
#     $self : 󥹥󥹤Υե
# 
#     $id   : åID
# 
#
# 
#
sub getClusterTableID {
    my $self = shift;

	my $cmd = $self->{'CommandStr'};
    my $file = $self->{'Cache'}->{'Index'}->{$cmd}->{'file'};
	if($file =~ /(\d+_\d+)/) {
		return $1;
	}
	return ;
}

###############################################################################
# ̾
#     isOnCache()
# 
#     ꤷơȥȤμ¹Է̤å˻ĤäƤ뤫Ĵ٤롣
# 
#     $self : 󥹥󥹤Υե
#     $cmnd : domclust¹ԥơȥ(ץ)
# 
#     1 : 㥷˻ĤäƤ롣
#     0 : 㥷˻ĤäƤʤ
# 
#     
# 
#
sub isOnCache {
    my $self = shift;
    my $cmnd = shift;
    my $rc = 0;

    $cmnd = $self->editStatement() unless(defined $cmnd);

    if($self->{'Cache'}) {
	my $cobj = $self->{'Cache'};
	$rc = $cobj->exists($cmnd);
    }

    return $rc;
}

###############################################################################
# ̾
#     countClusters()
# 
#     饹֤
# 
#     $self : 󥹥󥹤Υե
#     $cmnd : domclust¹ԥơȥ(ץ)
# 
#     ʤ
# 
#     å奤ǥåϿƤ륯饹롣
# 
#
sub countClusters {
    my $self = shift;
    my $cmnd = shift;
    $cmnd = $self->{'CommandStr'} unless(defined $cmnd);

    my $ch = $self->{'Cache'};
    my $info = $ch->getAddInfo($cmnd);
    return $info->{'clusters'};
#    return $ch->{'Index'}{$cmnd}{'info'}{'clusters'};
}

###############################################################################
# ̾
#     getHeader()
# 
#     DomClustνϥإå(#ǻϤޤ)롣
# 
#     $self : 󥹥󥹤Υե
#     $cmnd : domclust¹ԥơȥ(ץ)
# 
#     ʤ
# 
#     å奤ǥåϿƤإåϤ롣
# 
#
sub getHeader {
    my $self = shift;
    my $cmnd = shift;
    $cmnd = $self->{'CommandStr'} unless(defined $cmnd);

    my $ch = $self->{'Cache'};
    my $info = $ch->getAddInfo($cmnd);
    return $info->{'header'};
}

###############################################################################
# ̾
#     getSpecies()
# 
#     DomClustνϷ̤˴ޤޤʪ̾(ά)ΥꥹȤ롣
# 
#     $self : 󥹥󥹤Υե
#     $cmnd : domclust¹ԥơȥ(ץ)
# 
#     ʤ
# 
#     å奤ǥåϿƤʪ̾Ф
#     ꥹȤȤ֤
# 
#
sub getSpecies {
    my $self = shift;
    my $cmnd = shift;
    $cmnd = $self->{'CommandStr'} unless(defined $cmnd);

    my $ch = $self->{'Cache'};
    my $info = $ch->getAddInfo($cmnd);
#    return split(",", $info->{'species'});
    return @{$info->{'species'}};
}

###############################################################################
# ̾
#     getInGroup()
# 
#     DomClustνϷ̤˴ޤޤInGroupʪ̾(ά)ΥꥹȤ롣
# 
#     $self : 󥹥󥹤Υե
#     $cmnd : domclust¹ԥơȥ(ץ)
# 
#     ʤ
# 
#     å奤ǥåϿƤInGroupʪ̾Ф
#     ꥹȤȤ֤
# 
#
sub getInGroup {
    my $self = shift;
    my $cmnd = shift;
    $cmnd = $self->{'CommandStr'} unless(defined $cmnd);

    my $ch = $self->{'Cache'};
    my $info = $ch->getAddInfo($cmnd);
#    return split(",", $info->{'ingroup'});
#    return @{$info->{'ingroup'}};
#    return (defined $info->{'ingroup'} ? @{$info->{'ingroup'}} : undef);
#    (defined $info->{'ingroup'} ? @{$info->{'ingroup'}} : undef);
    (defined $info->{'ingroup'} ? @{$info->{'ingroup'}} : ());
}

###############################################################################
# ̾
#     getOutGroup()
# 
#     DomClustνϷ̤˴ޤޤOutGroupʪ̾(ά)ΥꥹȤ롣
# 
#     $self : 󥹥󥹤Υե
#     $cmnd : domclust¹ԥơȥ(ץ)
# 
#     ʤ
# 
#     å奤ǥåϿƤOutGroupʪ̾Ф
#     ꥹȤȤ֤
# 
#
sub getOutGroup {
    my $self = shift;
    my $cmnd = shift;
    $cmnd = $self->{'CommandStr'} unless(defined $cmnd);

    my $ch = $self->{'Cache'};
    my $info = $ch->getAddInfo($cmnd);
#    return split(",", $info->{'outgroup'});
#    return @{$info->{'outgroup'}};
#    return (defined $info->{'outgroup'} ? @{$info->{'outgroup'}} : undef);
#    (defined $info->{'outgroup'} ? @{$info->{'outgroup'}} : undef);
    (defined $info->{'outgroup'} ? @{$info->{'outgroup'}} : ());
}

#==============================================================================
#------------------------------------------------------------------------------
# ʲΥ᥽åɤϡפˤʤ롩
#------------------------------------------------------------------------------
#==============================================================================

###############################################################################
# ̾
#     getClusters()
# 
#     饹ֹꤷʹߤΥ饹ɬפʿ롣
# 
#     $self  : 󥹥󥹤Υե
#     $cno   : 饹ֹ(ֹ)
#     $count : 饹
#     $cmnd  : domclust¹ԥơȥ(ץ)
# 
#     饹Υꥹ
# 
#     ǥեȤνϷꤷꤵ줿饹ֹ椫顢ꤵ줿
#     ĿʬΥ饹֤
# 
#     ǡ¤
#     @list = (
#              {'cluster' => 饹ֹ,
#               'subcluster => [
#                               {
#                                'ʪ̾' => {
#                                               'ORF̾' => {
#                                                           'gene' => ORF̾,
#                                                           'from' => ϰ,
#                                                           'to'   => λ,
#                                                          },
#                                              },
#
#                                Ʊ, ...
#                               },
#                               { Ʊ }, ...
#                              ],
#               'outgroup' => {
#                              'ʪ̾' => {
#                                             'ORF̾' => {
#                                                         'gene' => ORF̾,
#                                                         'from' => ϰ,
#                                                         'to'   => λ,
#                                                        },
#                                            },
#                               Ʊ, ...
#                             },
#              },
#              { Ʊ }, ....
#             );
#
sub getClusters {
    my $self  = shift;
    my $cno   = shift;
    my $count = shift;
    my $cmnd  = shift;
    $cmnd = $self->{'CommandStr'} unless(defined $cmnd);

    $cno   = 1   unless(defined $cno);

    my @list;
    my $clst;
    my $crec;

    my $ch = $self->{'Cache'};
    # Ƭ饹ޤǥå
#    while(my $line = $ch->getEachLine()) {
    while(my $line = $ch->getline()) {
	if($line =~ /^Cluster +(\d+)/) {
	    if($cno == $1) {
#		$clst = {};
#		$clst->{'cluster'}    = $1;
#		$clst->{'subcluster'} = [];
		$crec = {};
		$clst = {'cluster' => $1, 'subcluster' => [$crec]};
		push(@list, $clst);
		$count-- if(defined $count);
		last;
	    }
	}
    }

    if($clst->{'cluster'} == $cno || $cno == 0) {
        my($hom_cluster) = '';
	while(my $line = $ch->getline()) {
		my($flag);
        if($line =~ /^HomCluster +(\d+)/) {
            $hom_cluster = $1;
        }
	    elsif($line =~ /^Cluster +(\d+)/) {
		$count-- if(defined $count);
		last if($count < 0);

		$crec = {};
		$clst = {'cluster' => $1, 'subcluster' => [$crec]};
		push(@list, $clst);
#		$clst->{'cluster'}    = $1;
#		$clst->{'subcluster'} = [];
	    }
	    elsif($line =~ /^SubCluster +(\d+)/) {
		my $no = $1;
		if($no > 1) {
		    $crec = {};
		    push(@{$clst->{'subcluster'}}, $crec);
		}
	    }
	    elsif($line =~ /^OutGroup/) {
		if (! $clst->{'outgroup'}) {
			$clst->{'outgroup'} = {};
		}
		$crec = $clst->{'outgroup'};
	    }
	    elsif ($line =~ /^OuterGroup/)  {
		if (! $clst->{'outgroup'}) {
			$clst->{'outgroup'} = {};
		}
		$crec = $clst->{'outgroup'};
		$flag = 'outer';
	    }
	    elsif($line =~ /^\s*$/) {
		next;
	    }
	    elsif($line =~ /^(([a-z0-9]+):\S+)\s+(\d+)\s+(\d+)/i) {
		my $orf = $1;
		my $sp  = $2;
		my $fm  = $3;
		my $to  = $4;

		$crec->{$sp}{$orf} =  {'gene' => $orf, 'from' => $fm, 'to' => $to, 'flag' => $flag};
#		push(@{$crec->{$sp}}, {'gene' => $orf, 'from' => $fm, 'to' => $to});
	    }
	}
    }

##    my $info = $ch->getAddInfo($cmnd);
##    return split(",", $info->{'species'});

    return @list;
}

###############################################################################
1;#
###############################################################################
