#!/usr/bin/perl -s
use strict;
use FileHandle;
use IO::Socket;
use MBGD;
use RECOG;
package main;

#
$DomClustCommon::VER_DATA_FORMAT = 2;

###############################################################################
$main::CMD_deleteDomclustRes = "$ENV{'MBGD_HOME'}/WWW/bin/RECOG/deleteDomclustRes.pl";
$main::CMD_pickup_domclust_progress = '$MBGD_HOME/WWW/bin/RECOG/pickup_domclust_progress.pl';
$main::CMD_create_clustxref_recog = '$MBGD_HOME/WWW/bin/RECOG/create_clustxref.pl';

###############################################################################
                                                # DB 顼
$DomClustCommon::ERRNO_DB_ACCESS              = "D0001";
                                                # ե륢顼
$DomClustCommon::ERRNO_FILE_ACCESS            = "D0002";
                                                # б륯饹̵
$DomClustCommon::ERRNO_NO_CLUST_TAB           = "D0101";
                                                # MySQL ̤Ͽʪ濫
$DomClustCommon::ERRNO_NO_SPEC                = "D0102";

%DomClustCommon::ERRMSG = ( $DomClustCommon::ERRNO_DB_ACCESS
                            => "DB access error.",
                            $DomClustCommon::ERRNO_FILE_ACCESS
                            => "File access error.",
                            $DomClustCommon::ERRNO_NO_CLUST_TAB
                            => "No cluster table.",
                          );

###############################################################################
#
sub parseCommandOption {
    my($option) = shift;

    my $opt_ref={};
    foreach my $opt (split/ /,$option) {
        my($key, $val);
        if($opt=~/\=/) {
            ($key, $val) = split/=/, $opt;
            $opt_ref->{$key} = $val;
        } elsif(! $val) {
            $opt_ref->{$opt}++;
        }
    }

    # ץǻ̵Τϥǥեͤꤹ
    if(! exists $opt_ref->{'-out_format'}) {
        $opt_ref->{'-out_format'} = 'text';
    }
    if(! exists $opt_ref->{'-output_type'}) {
        $opt_ref->{'-output_type'} = 'complete';
    }
    if(! exists $opt_ref->{'-dbtype'}) {
        $opt_ref->{'-dbtype'} = 'MBGD';
    }

    # ץǻꤷϥե뤬ϽΤǤ뤫ǧ
    my $outfile = $opt_ref->{'-out'};
    my $errfile = $opt_ref->{'-err'};

    return $opt_ref;
}

###############################################################################
#
sub parseSelectOpt {
    my($qry) = shift;
    my($key);
    my($val);

    # select ץμ
    my $refOpt={};

    #
    $key = 'sim_measure';
    $val = $qry->param($key);
    if ($val =~ /^identity$/) {
        $refOpt->{'-di'} = '';
    }

    #
    $key = 'score';
    $val = $qry->param($key);
    if ($val ne '') {
        $refOpt->{'-SCORE'} = $val;
    }
    $refOpt->{'-SCORE'} = 60 if ($refOpt->{'-SCORE'} eq '');

    #
    $key = 'eval';
    $val = $qry->param($key);
    if ($val ne '') {
        $refOpt->{'-EVAL'} = $val;
    }
    $refOpt->{'-EVAL'} = 0.001 if ($refOpt->{'-EVAL'} eq '');

    #
    $key = 'pam';
    $val = $qry->param($key);
    if ($val ne '') {
        $refOpt->{'-PAM'} = $val;
    }

    #
    $key = 'ident';
    $val = $qry->param($key);
    if ($val ne '') {
        $refOpt->{'-IDENT'} = $val;
    }

    #
    $key = 'besthit';
    $val = $qry->param($key);
    if ($val ne '') {
        $refOpt->{'-BESTHIT'} = $val;
    }

    #
    $key = 'ratiocut';
    $val = $qry->param($key);
    if ($val ne '') {
        $refOpt->{'-RATIOCUT'} = $val;
    }

    return $refOpt;
}

###############################################################################
sub sprint_select_opt {
    my($ref) = shift;

    my(@cmd_list);

    #
    if (exists($ref->{'-di'})) {
        push(@cmd_list, "sim_measure=identity");
    }

    #
    if (exists($ref->{'-SCORE'})) {
        push(@cmd_list, "score=" . $ref->{'-SCORE'});
    }

    #
    if (exists($ref->{'-EVAL'})) {
        push(@cmd_list, "eval=" . $ref->{'-EVAL'});
    }

    #
    if (exists($ref->{'-PAM'})) {
        push(@cmd_list, "pam=" . $ref->{'-PAM'});
    }

    #
    if (exists($ref->{'-IDENT'})) {
        push(@cmd_list, "ident=" . $ref->{'-IDENT'});
    }

    #
    if (exists($ref->{'-BESTHIT'})) {
        push(@cmd_list, "besthit=" . $ref->{'-BESTHIT'});
    }

    #
    if (exists($ref->{'-RATIOCUT'})) {
        push(@cmd_list, "ratiocut=" . $ref->{'-RATIOCUT'});
    }

    #
    if (exists($ref->{'-SPEC'})) {
        push(@cmd_list, "species=" . $ref->{'-SPEC'});
    }

    #
    my($cmd) = join('&', @cmd_list);

    return $cmd;
}

###############################################################################
# ñʿͥåư
sub parse_numeric {
    my($v) = shift;

    $v =~ s#\s##g; # ʸν
    if ($v eq '') {
        return;
    }

    if ($v =~ /^[\+\-]?\d+$/) {
        # 
        return $v;
    }

    if ($v =~ /^[\+\-]?\d+\.\d*$/) {
        # ư
        return $v;
    }

    if ($v =~ /^\.\d+$/) {
        # ư.1  .5 ʤɡ
        return $v;
    }

    if ($v =~ /^[e][\+\-]\d+$/) {
        # ư e-01 ʤɡ
        $v = '1' . $v; #1e-01 Ѵ
        return $v;
    }

    if ($v =~ /^\d+[e][\+\-]\d+$/) {
        # ư123e-01 ʤɡ
        return $v;
    }

    if ($v =~ /^\d+\.\d+[e][\+\-]\d+$/) {
        # ư1.234567e-01 ʤɡ
        return $v;
    }

    # 嵭ʳϡ顼
    print STDERR "WARN :: NG numeric format :: [$v]\n";
    return;
}

###############################################################################
#
sub parseDomClustOpt {
    my($qry) = shift;
    my($key);
    my($val);

    # DomClustץμ
    my $refOpt={};

    #
    my($sim_measure);
    $key = 'sim_measure';
    $val = $qry->param($key);
    if ($val ne '') {
        if ($val =~ /^score$/i) {
            $refOpt->{'-S'} = '';
            $refOpt->{'-c'} = $qry->param('score');
            if ($refOpt->{'-c'} eq ''){
                $refOpt->{'-c'} = 60;
            }
        }
        elsif ($val =~ /^pam$/i) {
            $refOpt->{'-d'} = '';
            $refOpt->{'-c'} = $qry->param('pam');
        }
        else {    # elsif ($val =~ /^ident$/i) {
            $refOpt->{'-d'} = '';
            $refOpt->{'-c'} = $qry->param('identity');
            if ($refOpt->{'-c'} eq ''){
                $refOpt->{'-c'} = 80;
            }
        }
        $sim_measure = $val;
    }
    else {
        # ŤΥץ
        $key = '-S';
        $val = $qry->param($key);
        $val = parse_numeric($val);
        if ($val ne '') {
            $refOpt->{'-S'} = '';
            my($s) = $qry->param('score');
            $s = parse_numeric($s);
            $refOpt->{'-c'} = $s;
            if ($refOpt->{'-c'} eq ''){
                $refOpt->{'-c'} = 60;
            }
            $sim_measure = 'score';
        }
        else {
            $refOpt->{'-d'} = '';
            my($p) = $qry->param('pam');
            $p = parse_numeric($p);
            $refOpt->{'-c'} = $p;
            $sim_measure = 'pam';
        }
    }

    #
    $key = 'cutoff_ingroup';
    $val = $qry->param($key);
    if ($val ne '') {
        $refOpt->{'-ci'} = $val;
    }

    # Property::HomolParam  missdist ˤ碌
    $key = 'missdist';
    $val = $qry->param($key);
    $val = parse_numeric($val);
    if ($val ne '') {
        $refOpt->{'-m'} = $val;
    }
    else {
        # ŤΥץ
        $key = '-m';
        $val = $qry->param($key);
        $val = parse_numeric($val);
        $refOpt->{'-m'} = $val;
    }
#    if ($refOpt->{'-m'} eq '') {
#        if ($sim_measure =~ /^score$/i) {
#            $refOpt->{'-m'} = $refOpt->{'-c'} - 10;
#        }
#        else {
#            $refOpt->{'-m'} = $refOpt->{'-c'} + 10;
#        }
#    }

    #
    $key = 'missdist_ratio';
    $val = $qry->param($key);
    $val = parse_numeric($val);
    if ($val ne '') {
        $refOpt->{'-mr'} = $val;
    }
    else {
        # ŤΥץ
        $key = '-mr';
        $val = $qry->param($key);
        $val = parse_numeric($val);
        $refOpt->{'-mr'} = $val;
    }

    #
    $key = 'cutoff2';
    $val = $qry->param($key);
    $val = parse_numeric($val);
    if ($val ne '') {
        $refOpt->{'-C'} = $val;
    }
    else {
        # ŤΥץ
        $key = '-C';
        $val = $qry->param($key);
        $val = parse_numeric($val);
        $refOpt->{'-C'} = $val;
    }
    $refOpt->{'-C'} = 80 if ($refOpt->{'-C'} eq '');

    #
    $key = 'coverage2';
    $val = $qry->param($key);
    $val = parse_numeric($val);
    if ($val ne '') {
        $refOpt->{'-V'} = $val;
    }
    else {
        # ŤΥץ
        $key = '-V';
        $val = $qry->param($key);
        $val = parse_numeric($val);
        $refOpt->{'-V'} = $val;
    }
    $refOpt->{'-V'} = 0.6 if ($refOpt->{'-V'} eq '');

    # ŤΥץ
    $key = '-n';
    $val = $qry->param($key);
    $val = parse_numeric($val);
    $refOpt->{'-n'} = $val;
    $refOpt->{'-n'} = 1 if ($refOpt->{'-n'} eq '');

    #
    $key = '-ne';
    $val = $qry->param($key);
    $val = parse_numeric($val);
    $refOpt->{'-ne'} = $val;
    $refOpt->{'-ne'} = 1 if ($refOpt->{'-ne'} eq '');

    #
    $key = 'phylocut';
    $val = $qry->param($key);
    $val = parse_numeric($val);
    if ($val ne '') {
        $refOpt->{'-p'} = $val;
    }
    else {
        # ŤΥץ
        $key = '-p';
        $val = $qry->param($key);
        $val = parse_numeric($val);
        $refOpt->{'-p'} = $val;
    }
    $refOpt->{'-p'} = 0.5 if ($refOpt->{'-p'} eq '');

    #
    $key = 'clustmode';
    $val = $qry->param($key);
    if ($val =~ /^combined$/i) {
        $refOpt->{'-HO'} = '';
    }
    elsif ($val =~ /^homology$/i) {
        $refOpt->{'-H'} = '';
    }
    else {
        # ŤΥץ
        $key = '-H';
        $val = $qry->param($key);
        $refOpt->{'-H'} = $val;
    }

    #
    $key = 'adjincl';
    $val = $qry->param($key);
    $val = parse_numeric($val);
    if ($val ne '') {
        $refOpt->{'-ai'} = $val;
    }
    else {
        # ŤΥץ
        $key = '-ai';
        $val = $qry->param($key);
        $val = parse_numeric($val);
        $refOpt->{'-ai'} = $val;
    }
    $refOpt->{'-ai'} = 0.95 if ($refOpt->{'-ai'} eq '');

    #
    $key = 'adjovlp';
    $val = $qry->param($key);
    $val = parse_numeric($val);
    if ($val ne '') {
        $refOpt->{'-ao'} = $val;
    }
    else {
        # ŤΥץ
        $key = '-ao';
        $val = $qry->param($key);
        $val = parse_numeric($val);
        $refOpt->{'-ao'} = $val;
    }
    $refOpt->{'-ao'} = 0.8 if ($refOpt->{'-ao'} eq '');

    #
    $key = 'taxonlevel';
    $val = $qry->param($key);
    if (($val ne '') && ($val !~ /^none$/i)) {
        my($tax) = MBGD::Taxonomy->new();
        my(@tax_list) = $tax->get_species( { 'list_related' => $val } );
        my($tax_info) = '';
        foreach my$t (@tax_list) {
            if (@{$t} >= 2) {
                $tax_info .= ('{' . join(',', @{$t}) . '}');
            }
        }

        my($dir) = "$ENV{'MBGD_HOME'}/work";
        my($file_taxonlevel) = "$dir/taxonlevel.$$";
        my($fh) = FileHandle->new(">$file_taxonlevel");
        if ($fh) {
            $fh->print($tax_info);
            $fh->close();
            $refOpt->{'-t'} = $file_taxonlevel;
        }
    }

    #
    $key = 'horizweight';
    $val = $qry->param($key);
    $val = parse_numeric($val);
    if ($val ne '') {
        $refOpt->{'-Ohorizweight'} = $val;
    }
    $refOpt->{'-Ohorizweight'} = 0 if ($refOpt->{'-Ohorizweight'} eq '');

    #
    $key = 'taxMapSpec';
    $val = $qry->param($key);
    if (defined($val)) {
        $val =~ s#\s##g;
        my(@splist) = split(/\,/, $val);
        $refOpt->{'-OtaxMapSpec'} = join(',', sort(@splist));
    }

    #
    $key = 'otherOptions';
    $val = $qry->param($key);
    if ($val ne '') {
	$refOpt->{'#OtherOptions#'} = $val;
    }

    return $refOpt;
}

###############################################################################
#
sub sprint_domclust_opt {
    my($ref) = shift;

    my(@cmd_list);

    #
    if (exists($ref->{'-S'})) {
        push(@cmd_list, "sim_measure=score");
    }
    elsif (exists($ref->{'-d'})) {
        push(@cmd_list, "sim_measure=pam");
    }

    #
    if (exists($ref->{'-ci'})) {
        push(@cmd_list, "cutoff_ingroup=" . $ref->{'-ci'});
    }

    #
    if (exists($ref->{'-m'})) {
        push(@cmd_list, "missdist=" . $ref->{'-m'});
    }

    #
    if (exists($ref->{'-mr'})) {
        push(@cmd_list, "missdist_ratio=" . $ref->{'-mr'});
    }

    #
    if (exists($ref->{'-C'})) {
        push(@cmd_list, "cutoff2=" . $ref->{'-C'});
    }

    #
    if (exists($ref->{'-V'})) {
        push(@cmd_list, "coverage2=" . $ref->{'-V'});
    }

    #
    if (exists($ref->{'-n'})) {
        push(@cmd_list, "-n=" . $ref->{'-n'});
    }

    #
    if (exists($ref->{'-ne'})) {
        push(@cmd_list, "-ne=" . $ref->{'-ne'});
    }

    #
    if (exists($ref->{'-p'})) {
        push(@cmd_list, "phylocut=" . $ref->{'phylocut'});
    }

    #
    if (exists($ref->{'-HO'})) {
        push(@cmd_list, "clustmode=combined");
    }
    elsif (exists($ref->{'-H'})) {
        push(@cmd_list, "clustmode=homology");
    }

    #
    if (exists($ref->{'-ai'})) {
        push(@cmd_list, "adjincl=" . $ref->{'-ai'});
    }

    #
    if (exists($ref->{'-ao'})) {
        push(@cmd_list, "adjovlp=" . $ref->{'-ao'});
    }

    #
    if (exists($ref->{'-Ohorizweight'})) {
        push(@cmd_list, "horizweight=" . $ref->{'-Ohorizweight'});
    }

    #
    if (exists($ref->{'-OtaxMapSpec'})) {
        push(@cmd_list, "taxMapSpec=" . $ref->{'-OtaxMapSpec'});
    }

    #
    if (exists($ref->{'-Ooutgroup'})) {
        push(@cmd_list, "outgroup=" . $ref->{'-Ooutgroup'});
    }

    my($cmd) = join('&', @cmd_list);

    return $cmd;
}

###############################################################################
#
sub printWarnings {
    my($db) = shift;
    my($st) = shift;
    my($clid) = shift;
    my($outputFormat) = shift;

    if($clid) {
        my $status = getStatus($db, $clid);
        if($status) { # ¹Խλ or 顼λ
            if($outputFormat eq 'html') {
                $st->showWarnings($db, $clid);
            } else {
                $st->showWarnings_txt($db, $clid);
            }
            return;
        }
    }

    # 륯饹Υơʤ
    my($eid) = $DomClustCommon::ERRNO_FILE_ACCESS;
    my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
    printErrMsgExit($eid, $emsg, $clid);

    return;
}

###############################################################################
#
sub parseTargetSpecies {
    my(@param) = @_;
    my($refSpec) = {};

    foreach my $s (grep length($_), @param) {
        foreach my $p (split/,/,$s) {
            if(length($p) > 0) {
                $refSpec->{$p} = 1;
            }
        }
    }

    return $refSpec;
}

###############################################################################
# domclustμ¹Է̤mysqlϿ롣
sub convDomClustRes {
	my($fileDomclust, $fileTmp) = @_;
	my($fh);
	my($wh);

    #
	$fh = new FileHandle("$fileDomclust");
    if (!$fh) {
        my($eid) = $DomClustCommon::ERRNO_FILE_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg);

    }

    #
	$wh = new FileHandle("> $fileTmp");
    if (!$wh) {
        my($eid) = $DomClustCommon::ERRNO_FILE_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg);
    }

	my $res={};
    my $homres={};
	my $outres={};
    my ($hom_clust)='';
	my ($clust)=0;
	my ($subc) = 0;
	my ($outflag);
	while(my $line = $fh->getline()) {
		chomp($line);
		if($line =~ /^#/) { next;}
		if($line =~ /^\s/) { next;}

        if($line =~ /^HomCluster\s*(\d+)/) {
            $hom_clust = $1;
        }
		elsif($line =~ /^Cluster\s*(\d+)/) {
			$clust = $1;
			$res->{$clust}={};
            $homres->{$clust}=$hom_clust;
			$subc = 0;
			$outflag = 0;
			next;
		}

		if($line =~ /^SubCluster\s*(\d+)/) {
			$subc = $1;
			$res->{$clust}->{$subc}="";
			next;
		}

		if($line =~ /^OutGroup/) {
			$outres->{$clust}="";
			$outflag = 1;
			next;
		}

		if($line =~ /^OuterGroup/) {
			$outres->{$clust}="";
			$outflag = 2;
			next;
		}

		if($line =~ /\S+:\S+/) {
			if(!$subc) {
				$subc = 1; # SubClusterɽʤΤ1Ȥ롣
			}

			if($outflag) {
				my $r = $outres->{$clust};
				if(length($r) > 1) {
					$outres->{$clust} = $r . " " . $line;
				}
				else {
					$outres->{$clust} = $line;
				}
 				next;
			} else {
				my $r = $res->{$clust}->{$subc};
				if(length($r) > 1) {
					$res->{$clust}->{$subc} = $r . " " . $line;
				}
				else {
					 $res->{$clust}->{$subc} = $line;
				}
				next;
			}
		}
	}

	# ϥå˳Ǽǡ˽Ϥ
	foreach my $i (sort{$a<=>$b} keys %{$res}) {
        my($homout) = $homres->{$i};

		# outgroup뤫
		my $out;
		if(exists $outres->{$i}) {
			$out = $outres->{$i};
		}

		# SubClusterΥ
		foreach my $s (sort{$a<=>$b} keys %{$res->{$i}}) {
			my $res = $res->{$i}->{$s};
            printf($wh "%s\t%d\t%d\t%s", $homout, $i, $s, $res);
			if(length($out) > 1) {
				print $wh " Outgroup " . $out;
			}
			print $wh "\n";
		}
	}
	$wh->close();
	return $fileTmp;
}

###############################################################################
# domclustμ¹Է̤Ͽơ֥ǡϿ
sub createResultTableAndLoad {
	my($db) = shift;
    my($tabID) = shift;
    my($fileDomclust) = shift;
    my($sql);

	# ϿƤʤå롣
	# ϿƤ硢򲿤⤻֤
	if($db->exist_table($tabID)) {
		print STDERR "Already registered.";
		return ;
	}

    # ȥեdomclustμ¹Է̤parseΤϤ롣
    my($fileTmp) = "$main::DOMCLUST_TMP_DIR/tmp_clustgene_$tabID.txt";
    $fileTmp = convDomClustRes($fileDomclust, $fileTmp);
	
    # ȥեΥǡmysqlϿ뤿Υơ֥롣
    my($tabName) = "cluster_result_$tabID";
    $sql = "create table if not exists $tabName ("
         . "homclustid  int(11) default null,"
         . "clustid     int(11),"
         . "subclustid  int(11),"
         . "name        mediumtext,"
         . "primary key (clustid, subclustid))";

	$db->execute($sql);

    # ȥեΥǡmysqlϿ롣
    $sql = "load data local infile \'$fileTmp\' REPLACE into table $tabName";

	$db->execute($sql);

    # ȥե롣
    unlink($fileTmp);

    return;
}

###############################################################################
# domclustμ¹Է̤mysqlϿƤ뤫ǧ롣
sub existsResultColumn {
	my($db) = shift;
	my($id) = shift;
	my($tabname) = shift;

	if(!$tabname) {
		$tabname = $main::TBL_DOMRESULT;
	}
	
	$tabname = $tabname . "_" . $id;
	
	if($db->exist_table($tabname)) {
		my $sql = "select count(*) from $tabname";
		my $st = $db->execute($sql);
		my @num = $st->fetch();
		if($num[0] < 1) {
			return 0;
		} else {
			return 1;
		}
	}
	else {
		return 0;
	}
}

###############################################################################
# domclustμ¹Է̤ꡢ
# 饹ɽMBGDΥƥ꡼Ȱ̾mysqlϿ롣
sub convDomClustFuncRes {
    my($fileDomclust) = shift;
    my($fileTmp) = shift;
    my($delim) = shift;
    my($fh);
    my($wh);

    #
    if (!defined($delim)) {
        $delim = "\t";
    }

    #
    $fh = new FileHandle("$fileDomclust");
    if (!$fh) {
        my($eid) = $DomClustCommon::ERRNO_FILE_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg);
    }

    $wh = new FileHandle("> $fileTmp");
    if (!$wh) {
        my($eid) = $DomClustCommon::ERRNO_FILE_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg);
    }

    #
    my $before_cid;
    my @sps;
    while(my $line = $fh->getline()) {
        $line =~ s#[\r\n]*$##;

        if($line=~/^#HCID/) {
		   if($line =~/SCFuncTigr\t(.*)/) {
			   my $sps = $1;
		       @sps = split/\t/, $sps;
		   }
	    }

        next if($line=~/^\s*#/);
        next if($line=~/^\s*$/);

        # By default, split remove empty trailing fields.
		my($hcid,
           $cid,
           $cgene, $cfuncMbgd, $cfuncCog, $cfuncKegg, $cfuncTigr, $cdescr,
           $sid,
           $sgene, $sfuncMbgd, $sfuncCog, $sfuncKegg, $sfuncTigr, $sdescr,
           @data) = split(/\t/, $line . "\t" . 'END');
        pop(@data); # remove dummy(='END') data.

        #
        my($phylopat) = '';
        my($spnum)    = 0;
        my($orfnum)   = 0;
        foreach my$sp_gene (@data) {
            my(@gene) = split(' ', $sp_gene);
            my($n) = scalar(@gene);
            if ($n != 0) {
                $phylopat .= '1';
                $spnum++;
                $orfnum += $n;
            }
            else {
                $phylopat .= '0';
            }
        }

        #
        $wh->print(join($delim, $hcid,
                                $cid,
                                $sid,
                                $phylopat, $spnum, $orfnum,
                                $cgene, $cfuncMbgd, $cfuncCog, $cfuncKegg, $cfuncTigr, $cdescr,
                                $sgene, $sfuncMbgd, $sfuncCog, $sfuncKegg, $sfuncTigr, $sdescr,
                                join("\t", @data),
                   ), "\n");
	}
	$wh->close();
}

###############################################################################
# domclustμ¹Է̤ꡢ
# 饹ɽMBGDΥƥ꡼Ȱ̾Υơ֥mysqlϿ롣
sub createFunctionTableAndLoad {
	my($db) = shift;
    my($tabID) = shift;
    my($fileDomclust) = shift;
    my($sql);

    # ȥեdomclustμ¹Է̤parseΤϤ롣
    my($delim) = '_RECOG_';
    my($fileTmp) = "$main::DOMCLUST_TMP_DIR/tmp_clustfunc_$tabID.txt";
    convDomClustFuncRes($fileDomclust, $fileTmp, $delim);

    # ȥեΥǡmysqlϿ뤿Υơ֥롣
    my($tabName) = "cluster_func_$tabID"; # cluster_func_clust2sql_
    $sql = "create table if not exists $tabName ("
         . "homclustid  int default null,"
         . "clustid     int not null,"
         . "subclustid  int not null,"
         . "phylopat    text,"
         . "spnum       int,"
         . "orfnum      int,"
         . "cgene       varchar(24),"
         . "cmbgd       varchar(24),"
         . "ccog        varchar(24),"
         . "ckegg       varchar(24),"
         . "ctigr       varchar(24),"
         . "cdescr      text,"
         . "sgene       varchar(24),"
         . "smbgd       varchar(24),"
         . "scog        varchar(24),"
         . "skegg       varchar(24),"
         . "stigr       varchar(24),"
         . "sdescr      text,"
         . "data        mediumtext,"
         . "primary key (clustid, subclustid))";

    $db->execute($sql);

    # ȥեΥǡmysqlϿ롣
    $sql = "load data local infile '$fileTmp' REPLACE into table $tabName fields terminated by '$delim'";

    $db->execute($sql);

    # ȥե롣
    unlink($fileTmp);

    return;
}

###############################################################################
# domclustμ¹Է̤ꡢ
# 饹ɽMBGDΥƥ꡼Ȱ̾Υơ֥뤬ϿƤ뤫ǧ
sub existsFuncColumn {
	my($db) = shift;
    my($id) = shift;
    my($tabname) = shift;

    if(!$tabname) {
        $tabname = $main::TBL_DOMFUNC;
    }

    $tabname = $tabname . "_" . $id;

    if($db->exist_table($tabname)) {
        my $sql = "select count(*) from $tabname";
        my $st = $db->execute($sql);
        my @num = $st->fetch();
        if($num[0] < 1) {
            return 0;
        } else {
            return 1;
        }
    }
    else {
        return 0;
    }
}

###############################################################################
# ξΥơ֥ꡢɬפʥ롣
# 
#t1.饹򥫥Ȥб륯饹groupǡݻ
#t2.֥饹ΰ
#t3.֥饹func
#t4.饹ΰ
sub getOutputColumn {
	my $db = shift;
	my $clusterID = shift;

	my $tablegene = $main::TBL_DOMRESULT . "_" . $clusterID;
    my $tablefunc = $main::TBL_DOMFUNC . "_" . $clusterID;

	my $sql = "select t1.clustid, t4.name, t5.name, t1.subclustid, t2.name, t3.name, t1.name from $tablegene t1 inner join ( $tablefunc t2 inner join ( $tablefunc t3 inner join ( $tablefunc t4 inner join $tablefunc t5 on t4.clustid=t5.clustid and t4.subclustid=0 and t5.subclustid=0 and t4.dbname=\'gene\' and t5.dbname=\'mbgd\') on t3.clustid=t5.clustid and t3.dbname=\'mbgd\') on t2.clustid=t3.clustid and t2.subclustid=t3.subclustid and t2.dbname=\'gene\') on t1.clustid=t2.clustid and t1.subclustid=t2.subclustid";

	my $dbh = $db->execute($sql);

	return $dbh;

}

###############################################################################
# domclustμ¹Է̤Ͽơ֥
sub createStatusTable {
	my($db) = shift;
	
    # ȥեΥǡmysqlϿ뤿Υơ֥롣
    my $sql = "create table if not exists $main::TBL_DOMINDEX ("
            . "clusterID mediumtext,"
            . "status int(11),"
            . "cmd mediumtext,"
            . "name mediumtext,"
            . "cdate timestamp)";

    $db->execute($sql);

    return;
}

###############################################################################
# domclustμ¹ status=1
sub insertStartStatus {
	my($db) = shift;
	my($id) = shift;
	my($cmd) = shift;

    createStatusTable($db);
	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "insert into $main::TBL_DOMINDEX (clusterID,status,cmd,cdate) "
                . "values ('$id', 1, '$cmd', current_timestamp())";
		$db->execute($sql);
	} else {
		print STDERR "Table $main::TBL_DOMINDEX is not exists.\n";

        my($eid) = $DomClustCommon::ERRNO_DB_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg, $id);
	}
}

###############################################################################
# domclustμ¹Խλ status=2
sub updateEndStatus {
	my($db) = shift;
    my($id) = shift;
	my($name) = shift;

    createStatusTable($db);
	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "update $main::TBL_DOMINDEX set status=2, name=\'$name\' where clusterID=\'$id\'";
		$db->execute($sql);
	} else {
        print STDERR "Table $main::TBL_DOMINDEX is not exists.\n";

        my($eid) = $DomClustCommon::ERRNO_DB_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg, $id);
    }
}

###############################################################################
# ޥɤбclusterID֤
sub getTabid {
	my($db) = shift;
    my($cmd) = shift;

	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "select clusterID from $main::TBL_DOMINDEX where cmd=\'$cmd\'";
		my $st = $db->execute($sql);
		return $st->fetch()->[0];
	}
}

###############################################################################
# إå֤
sub getHeaderInfo {
	my($db) = shift;
	my($id) = shift;
	my($param_ref) = {};

	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "select * from $main::TBL_DOMINDEX where clusterID=\'$id\'";
		my $st = $db->execute($sql);
		if ($st->rows() == 0) {
			return undef();
		}
        my($ref) = $st->fetchrow_hashref();
		my $name  = $ref->{'name'};
		my $cdate = $ref->{'cdate'};

		my @param = split/ /, $name;
		foreach my $p (@param) {
			my($key, $value) = split/=/,$p;
			my @values = split/,/,$value;
			if(scalar(@values) > 1) {
				$param_ref->{$key} = \@values;
			} elsif(($key eq 'outgroup') || ($key eq 'ingroup')) {
				$param_ref->{$key} = \@values;
			}
			else {
				$param_ref->{$key} = $value;
			}
		}
        $param_ref->{'cdate'} = $cdate;
	}
	return $param_ref;
}

###############################################################################
# ơ֤ 
sub getStatus {
	my($db) = shift;
	my($id) = shift;


    my($sta) = $db->exist_table($main::TBL_DOMINDEX);
    if($sta) {
		my $sql = "select * from $main::TBL_DOMINDEX where clusterID=\'$id\'";
		my $st = $db->execute($sql);
		my $rows = $st->rows();
		if($rows == 0) {
            print STDERR "DBG :: Can not found cluster [ID=$id]\n";
            return 0;
		} else {
            my $ref = $st->fetchrow_hashref();
			return $ref->{'status'};
		}
	}

    return;
}
###############################################################################
# λơϿ
sub uploadFinishStatus {
    my($db) = shift;
    my($id) = shift;
    my($name) = shift;

    if($db->exist_table($main::TBL_DOMINDEX)) {
        my $sql = "update $main::TBL_DOMINDEX set status=-1, name=\'$name\' where clusterID=\'$id\'";
        $db->execute($sql);
    } else {
        print STDERR "Table $main::TBL_DOMINDEX is not exists.\n";

        my($eid) = $DomClustCommon::ERRNO_DB_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg, $id);
    }
}

###############################################################################
# 顼ơϿ
sub uploadErrorStatus {
	my($db) = shift;
    my($id) = shift;

	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "update $main::TBL_DOMINDEX set status=-99 where clusterID=\'$id\'";
		$db->execute($sql);
	} else {
        print STDERR "Table $main::TBL_DOMINDEX is not exists.\n";

        my($eid) = $DomClustCommon::ERRNO_DB_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg, $id);
    }
}

###############################################################################
# Ƽ¹ԤΥơѹ
sub uploadRetryStatus {
	my($db) = shift;
	my($id) = shift;
	
	my($cnt)=0;
	
	# execƼ¹Ԥ뤿ᡢåơ֥
	&deleteCacheTable($db, $id);

	if($db->exist_table($main::TBL_DOMINDEX)) {
		# 󥿡鲿¹Ԥ줿
		my $sql = "select counter from $main::TBL_DOMINDEX where clusterID=\'$id\'";
		my $sth = $db->execute($sql);
		my $res = $sth->fetch();
        if($res) {
            $cnt = $res->[0];
        } else {
            $cnt = 0;
			print STDERR "column \'counter\' is not exists. clusterID is $id.\n";

            my($eid) = $DomClustCommon::ERRNO_NO_CLUST_TAB;
            my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
            printErrMsgExit($eid, $emsg, $id);
		}

		# ȥåפƼ¹ԥơѹ
		$cnt++;
		$sql = "update $main::TBL_DOMINDEX set status=0, counter=$cnt where clusterID=\'$id\'";
		$db->execute($sql);
	}
	else {
		print STDERR "Table $main::TBL_DOMINDEX is not exists.\n";

        my($eid) = $DomClustCommon::ERRNO_DB_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg, $id);
	}
}

###############################################################################
# Ƽ¹ԤΤᡢ¹ԥޥɤ饪ץϿ
sub idtoOpt {
	my($db) = shift;
	my($id) = shift;
	my %dc_opt;
	my $cmd;
	my @species;
	my @outgroup;
	my @option;

	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "select cmd from $main::TBL_DOMINDEX where clusterID=\'$id\'";
		my $sth = $db->execute($sql);
        my $res = $sth->fetch();
		if($res) {
            $cmd  = $res->[0];
        }
		if(!$cmd) {
			print STDERR "column \'cmd\' is not exists. clusterID is $id.\n";

            my($eid) = $DomClustCommon::ERRNO_NO_CLUST_TAB;
            my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
            printErrMsgExit($eid, $emsg, $id);
		}

		# ޥʸΥץҤ
		if($cmd =~ /-SPEC=(\S+)/) {
			@species = split/,/,$1;
		}
		if($cmd =~ /RECOG\/domclust (\-.*)/) {
			@option = split/ /,$1;
		}
		
		# ץʬ
		foreach my $op (@option) {
			if($op =~ /-Ooutgroup=(\S+)/) {
				@outgroup = split/,/,$1;
				$dc_opt{-O} = sprintf("outgroup=%s", join(',', @outgroup));
			}
			elsif($op =~ /(\-\w+)([\d\.]+)/) {
				my $k = $1;
				my $v = $2;

				# -S, -d, -H ꤵ줿硢ͤ on ʤ饪ץ
				#                                   offʤ̵Ȥ롣
				if($k eq '-S' || $k eq '-d' || $k eq '-H') {
					if($v eq 'on') {
						$dc_opt{$k} = '';
					}
				}
				# -R, -o ̵뤹
				elsif($k eq '-R' || $k eq '-o') {
					next;
				}
				# 嵭ʳʤ顢ͤꤵƤ˸¤ꡢͤؼ
				else {
					$dc_opt{$k} = $v if(defined $v && $v =~ /\S+/);
				}
			}
			else {
				# do nothing
			}
		}
	}
	else {
		print STDERR "Table $main::TBL_DOMINDEX is not exists.\n";

        my($eid) = $DomClustCommon::ERRNO_DB_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg, $id);
	}

	return (\@species, \%dc_opt);
}

###############################################################################
# retryƤOKɤå.
sub canRetry {
	my($db) = shift;
	my($cid) = shift;

	if($db->exist_table($main::TBL_DOMINDEX)) {
        my $sql = "select counter from $main::TBL_DOMINDEX where clusterID=\'$cid\'";
        my $sth = $db->execute($sql);
        my $res = $sth->fetch();
        if($res) {
			my $cn = $res->[0];
			if($cn < $main::DOMCLUST_RETRY_COUNT) {
				return 1;
			}
		}
	}
	return 0;
}

###############################################################################
#
sub addRetryCountOver {
	my($db) = shift;
    my($cid) = shift;

	my $warn;
	if($db->exist_table($main::TBL_DOMINDEX)) {
        my $sql = "select warning from $main::TBL_DOMINDEX where clusterID=\'$cid\'";
        my $sth = $db->execute($sql);
        my $res = $sth->fetch();
        if($res) {
            $warn = $res->[0];
        }
		if($warn) {
			$warn .= "\n" . "Retry count over. Can not exec domclust.";
		} else {
			$warn .= "Retry count over. Can not exec domclust.";
		}

		$sql = "update $main::TBL_DOMINDEX set warning=\'$warn\', status=-99 where clusterID=\'$cid\'";
		$db->execute($sql);
		return 1;
    }
	return 0;
}

###############################################################################
# phylopat åơ֥
sub deletePhylopatCacheTable {
    my($db) = shift;
    my($cid) = shift;

    if ($cid !~ /^\d+\_\d+$/) {
        # cluster ID ΥեޥåȰ۾
        return;
    }

    #
    foreach my$tab ($main::TBL_PHYLORESULT) {
        my $tabname = $tab . "_" . $cid;
        my $sql = "drop table if exists $tabname";
        $db->execute($sql);
    }

    #
    my $tabname = $main::TBL_PHYLOINDEX;
    if ($db->exist_table($tabname)) {
        my $sql = "delete from $tabname where clust_tab_id=\'$cid\'";
        print STDERR "DBG :: Delete phylopat [ID=$cid]\n";
        eval {
            $db->execute($sql);
        };
    }

    return;
}

###############################################################################
# phylopat åơ֥
sub deletePhylopatCacheTableByDomclustId {
    my($db) = shift;
    my($cid) = shift;

    my($tab) = $main::TBL_PHYLOINDEX;
    my($src_id) = "-SRC_CLUST_TAB_ID=$cid";
    my($sql) = "select * from $tab where cmd like '%$src_id%'";
    my($sth) = eval { $db->execute($sql) };
    if ($@) {
        return;
    }

    while(my$ref = $sth->fetchrow_hashref()) {
        my($id_phylopat) = $ref->{'clust_tab_id'};
        deletePhylopatCacheTable($db, $id_phylopat);
    }

    return;
}

###############################################################################
# CoreAligner åơ֥
sub deleteCoreAlignerCacheTable {
    my($db) = shift;
    my($cid) = shift;

    if ($cid eq '#ALL#') {
	# delete all corealign
    } elsif ($cid !~ /^\d+\_\d+$/) {
        # cluster ID ΥեޥåȰ۾
        return;
    }

    #
    foreach my$tab ($main::TBL_CORERESULT) {
        my $tabname = $tab . "_" . $cid;
        my $sql = "drop table if exists $tabname";
        $db->execute($sql);
    }

    #
    my $tabname = $main::TBL_COREINDEX;
    if ($db->exist_table($tabname)) {
        my $sql;
	if ($cid eq '#ALL#') {
		$sql = "delete from $tabname";
	} else {
		$sql = "delete from $tabname where core_tab_id=\'$cid\'";
	}
        print STDERR "DBG :: Delete phylopat [ID=$cid]\n";
        eval {
            $db->execute($sql);
        };
    }

    return;
}

###############################################################################
sub findCoreAlignerCacheTable {
	my($db,$core_id) = shift;
	if ($core_id !~ /^\d+\_\d+$/) {
		return;
	}
	if ($db->exist_table($main::TBL_COREINDEX)) {
		my($sql) = "select * from $main::TBL_COREINDEX where core_tab_id=\'$core_id\'";
		my($sth) = $db->execute($sql);
		my(@ans) = $sth->fetchrow_hashref;
		return @ans;
	}
}

###############################################################################
# CoreAligner åơ֥
sub deleteCoreAlignerCacheTableByDomclustId {
    my($db) = shift;
    my($cid) = shift;

    my($tab) = $main::TBL_COREINDEX;
    my($src_id) = "-CLUST_TAB_ID=\\'$cid\\'";
    my($sql) = "select * from $tab where cmd like '%$src_id%'";
    my($sth) = eval { $db->execute($sql) };
    if ($@) {
        return;
    }

    while(my$ref = $sth->fetchrow_hashref()) {
        my($id_core) = $ref->{'core_tab_id'};
        deleteCoreAlignerCacheTable($db, $id_core);
    }

    return;
}

###############################################################################
# taxmap åơ֥
sub deleteTaxmapCacheTable {
    my($db) = shift;
    my($mid) = shift;

    if ($mid !~ /^\d+\_\d+$/) {
        # ID ΥեޥåȰ۾
        return;
    }

    foreach my$tab ($main::TBL_TAXMAPRESULT) {
        my $tabname = $tab . "_" . $mid;
        my $sql = "drop table if exists $tabname";
        $db->execute($sql);
    }

    my $tabname = $main::TBL_TAXMAPINDEX;
    my $sql = "delete from $tabname where mapspecid=\'$mid\'";
    print STDERR "DBG :: Delete taxmap [ID=$mid]\n";
    eval {
        $db->execute($sql);
    };

    return;
}

###############################################################################
sub deleteCacheTableAll {
	my($db) = @_;
	my($sql) = "select clusterID from $main::TBL_DOMINDEX";
	my($sth) = $db->execute($sql);
	while (($a) = $sth->fetchrow_array) {
		deleteCacheTable($db, $a);
	}
}
###############################################################################
# domclust åơ֥
sub deleteCacheTable {
    my($db) = shift;
    my($cid) = shift;

    if ($cid !~ /^\d+\_\d+$/) {
        # cluster ID ΥեޥåȰ۾
        return;
    }

    foreach my$tab ($main::TBL_DOMRESULT,
                    $main::TBL_DOMFUNC,
                    $main::TBL_DOMCACHE,
                    $main::TBL_DOMSCORE,
                    $main::TBL_DOMTREE) {
        my $tabname = $tab . "_" . $cid;
        my $sql = "drop table if exists $tabname";
        $db->execute($sql);
    }

    my $tabname = $main::TBL_DOMINDEX;
    my $sql = "delete from $tabname where clusterID=\'$cid\'";
    print STDERR "DBG :: Delete cluster [ID=$cid]\n";
    eval {
        $db->execute($sql);
    };

    # domclust dump եκ
    my($fileDomclustDump) = "$ENV{'MBGD_HOME'}/MBGD.tmp/clustdump_$cid";
    unlink("$fileDomclustDump");

    # UPGMA ̤κ(phylopat)
    deletePhylopatCacheTableByDomclustId($db, $cid);

    # Core ̤κ(corealigner)
    deleteCoreAlignerCacheTableByDomclustId($db, $cid);

    return;
}

###############################################################################
# domclust åơ֥
sub deleteCacheTableBySpec {
    my($db) = shift;
    my($spec) = shift;

    my $tabname = $main::TBL_DOMINDEX;
    my $sql = "select * from $tabname";
    my($sth) = $db->execute($sql);
    while (my$ref=$sth->fetchrow_hashref()) {
        my($spec_list) = ($ref->{'cmd'} =~ /\-SPEC\=(\S+)/);
        foreach my$sp (split(/,/, $spec_list)) {
            if ($sp eq $spec) {
                deleteCacheTableBySpec($db, $ref->{'clusterID'});
                last;
            }
        }
    }

    return;
}

###############################################################################
# domclustwarningϿ
sub uploadWarnings {
	my($db) = shift;
	my($cid) = shift;
	my($warfile) = shift;

	my $warn;
	my $fh = new FileHandle($warfile);
    if (!$fh) {
        my($eid) = $DomClustCommon::ERRNO_FILE_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg, $cid);
    }
	while(my $line = $fh->getline) {
		$warn .= $line;
	}
	$fh->close;

	if(!$warn) { return; }
	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "update $main::TBL_DOMINDEX set warning=\'$warn\' where clusterID=\'$cid\'";
        $db->execute($sql);
	}
} 

###############################################################################
# domclust̤clusterϿ
sub uploadNdomclust {
	my($db) = shift;
	my($cid) = shift;
	my($num) = shift;

	if($num > 0) { 
		if($db->exist_table($main::TBL_DOMINDEX)) {
			my $sql = "update $main::TBL_DOMINDEX set ncluster=$num where clusterID=\'$cid\'";
			$db->execute($sql);
		}
	}
}

###############################################################################
#
sub setupSigTermFunctionForLocal {
    $SIG{TERM} = sub {
        print STDERR "DBG :: Called :: sigTermFunctionForLocal()\n";

        # Υơ֥
        my($db) = MBGD::DB->new($main::DBNAME_RECOG);
        deleteCacheTable($db, $DomClustCommon::TAB_ID_CLUSTER);

        die("DBG :: Terminated by sigterm.");    
    };

    return;
}

###############################################################################
#
sub execDomClustO11Local {
    my($clustid) = shift;
    my($cmd) = shift;
    my($fileListOut) = shift;

    #
    my($file_o11) = $fileListOut . '.o11';

    #
    $cmd .= ' -o11';
    system("$cmd > $file_o11.$$");

    unlink("$file_o11");
    rename("$file_o11.$$", "$file_o11");

    return;
}

###############################################################################
#
sub execDomClustLocal {
    my($clustid) = shift;
    my($cmd) = shift;
    my($fileListOut) = shift;
    my($fileStderr) = shift;
    my($fileProgress) = shift;
    my($fileTreeOut) = $fileListOut . '.tree';
    my($fileTree_o11) = $fileListOut . '.o11';
    my($fhr);
    my($fhe);

    #
    execDomClustO11Local($clustid, $cmd, $fileListOut);
#    my($cmd_o11) = $cmd;
#    $cmd_o11 =~ s# -o1 # -o11 #;
#    system("$cmd_o11 > $fileTree_o11");

    #
    $cmd .= ' -o1';

    #
    my($clustdumpid) = ($cmd =~ /clustdump_(\S+)/);
    if ($main::SAVE_args{'tabid'}) {
        $clustdumpid = $main::SAVE_args{'tabid'};
    }
    print STDERR "DBG :: DUMP ID :: $clustdumpid\n" if ($main::DEBUG);

    #
    my($fileScore) = "$ENV{'MBGD_HOME'}/work/tmp_output_score.$$";
    unlink($fileScore);
    $cmd .= " -OoutputScore=$fileScore";

    #
    my($mapspec);
    my($fileMapout) = "$ENV{'MBGD_HOME'}/work/tmp_taxmapout.$$";
    unlink($fileMapout);
    if ($cmd =~ /\-OtaxMapSpec\=(\S+)/) {
        $mapspec = $1;
        $cmd .= " -OtaxMapOut=$fileMapout -OnoReplaceSpTreeLeafName ";
    }

    #
print STDERR "DBG :: EXEC :: $cmd\n";
    $fhr = new FileHandle("$cmd 2>&1 1>$fileTreeOut |");
    $fhe = new FileHandle(">$fileStderr");
    $fhe->autoflush();
    my($fhp) = new FileHandle(">>$fileProgress");
    if (!$fhp) {
        die("Can not open $fileProgress($!)");
    }
    $fhp->autoflush();
 
TOP:
    while($_ = $fhr->getline()) {
        foreach my$pat (@RECOG::PAT_progress) {
            if (/^$pat/i) {
                $fhp->print($_);
                next TOP;
            }
        }
        $fhe->print($_);
    }
    $fhe->close();
    $fhp->close();

    #
    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);
    load_cluster_score($db, $clustid, $fileScore);
    unlink($fileScore);

    #
    load_taxmapout($db, $clustdumpid, $clustid, $fileMapout, $mapspec);
    unlink($fileMapout);

    #
    my($cmd2) = "$main::PROG_DOMCLUST_TREE2FLAT $fileTreeOut > $fileListOut";
    system("$cmd2");
}

###############################################################################
# for qsub
sub setupSigTermFunctionForQsub {
    $DomClustCommon::JOBID_QSUB = '';

    $SIG{TERM} = sub {
        print STDERR "DBG :: Called :: sigTermFunctionForQsub()\n";

        if ($DomClustCommon::JOBID_QSUB ne '') {
            # job ¹
            my($cmd) = "$main::CMD_qdel $DomClustCommon::JOBID_QSUB";
            system("$cmd");

            # job λΤԤ
            $cmd = "$main::CMD_qstat $DomClustCommon::JOBID_QSUB";
            for(;;) {
                my($ret) = system("$cmd");
                if (($ret >> 8) != 0) {
                    #  JOB ¸ߤʤʡὪλ
                    last;
                }
                print STDERR "DBG :: Waiting... jobid=$DomClustCommon::JOBID_QSUB\n";
                sleep(5);
            }
        }

        # Υơ֥
        my($db) = MBGD::DB->new($main::DBNAME_RECOG);
        deleteCacheTable($db, $DomClustCommon::TAB_ID_CLUSTER);

        die("DBG :: Terminated by sigterm.");
    };

    return;
}

###############################################################################
#
sub getJobidByJobfile {
    my($filename) = shift;

    my($fhJobid) = FileHandle->new("$filename");
    if (!$fhJobid) {
        my($eid) = $DomClustCommon::ERRNO_FILE_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg);
    }
    my($jobid) = $fhJobid->getline();
    ($jobid) = ($jobid =~ /(\d+)/);
    $fhJobid->close();

    return $jobid;
}

###############################################################################
#
sub waitDomClustQsub {
    my($jobid) = shift;

    # PBS  JOB λޤԤ
    my($cmd) = "$main::CMD_qstat $jobid";
    for(;;) {

        my($ret);
        if (0) {
            # system ѤȡʲΥ顼ȯ뤳Ȥäʤʤ
            # > No Permission.
            # > qstat: cannot connect to server edge (errno=15007)
            $ret = system("$cmd");
        }
        else {
            `$cmd`;
            $ret = $?;
        }
        my($sta) = $ret >> 8;
        if ($sta == 153) {
            #  JOB ¸ߤʤʡὪλ
            last;
        }
        elsif ($sta == 0) {
            # qstat ｪλ ==> JOB ϼ¹
        }
        else {
            # ¾Υ顼
            die("ERROR :: qstat returns $sta.");
        }

        sleep(5);
    }

    return;
}

###############################################################################
#
sub create_socket4progress {
    my($server_ref);
    my($port_base) = 53311;
    my($port_limit) = 500;    #
    my($port);
    for($port = $port_base; $port <= $port_base + $port_limit; $port++) {
        my(%opt) = ( 'LocalPort' => $port,
                     'Listen'    => 1,
                     'Proto'     => 'tcp',
                     'Reuse'     => 1,
                   );
        $server_ref = IO::Socket::INET->new(%opt);
        if ($server_ref) {
            print STDERR "DBG :: Use pot :: $port\n";
            last;
        }
    }


    return ($server_ref, $port);
}

###############################################################################
# qsub ޥɤȤ giag  domclust ¹
sub execDomClustQsub {
    my($clustid) = shift;
    my($cmdDomClust) = shift;
    my($fileListOut) = shift;
    my($fileStderr) = shift;
    my($fileProgress) = shift;
    my($fileTreeOut) = $fileListOut . '.tree';
    my($fileTree_o11) = $fileListOut . '.o11';
    my($fileScoreOut) = $fileListOut . '.score';
    my($optQueue) = '-q giga';

    my($server_ref, $port) = create_socket4progress();
    if (!$server_ref) {
         print STDERR "ERROR :: Can not create SOCKET\n";
         die;
    }

    #
#    my($cmd1) = "$cmdDomClust -o1 2>&1 1>$fileTreeOut"
#              . "| $main::CMD_tee $fileStderr"
#              . "| $main::CMD_pickup_domclust_progress > $fileProgress";

    # NFS 𤷤 $fileProgress ե򻲾Ȥȹ٤
    # rsh Ȥ⡼ȥۥȤǺ줿 $fileProgress ˥ԡ
    my($hostname) = `$main::CMD_hostname`;
    $hostname =~ s#[\r\n]*$##;
    my($cmd1) = "$cmdDomClust -o1 -OoutputScore=$fileScoreOut 2>&1 1>$fileTreeOut"
              . "| $main::CMD_tee -a $fileStderr"
              . "| $main::CMD_pickup_domclust_progress -HOST=$ENV{'SERVER_ADDR'} -PORT=$port";
#              . ">>$fileProgress";
#              . "| rsh $hostname '$main::CMD_cat >>$fileProgress'";
    print STDERR "DBG :: CMD :: $cmd1\n";

    #
    my($fileCmd)    = "$ENV{'MBGD_HOME'}/work/cmd_domclust.$$";
    my($fileLogOut) = "$ENV{'MBGD_HOME'}/work/cmd_domclust.out.$$";
    my($fileLogErr) = "$ENV{'MBGD_HOME'}/work/cmd_domclust.err.$$";
    my($fhCmd) = FileHandle->new(">$fileCmd");
    if (!$fhCmd) {
        my($eid) = $DomClustCommon::ERRNO_FILE_ACCESS;
        my($emsg) = $DomClustCommon::ERRMSG{"$eid"};
        printErrMsgExit($eid, $emsg);
    }

    #
    my($cmd_o11) = $cmd1;
    $cmd_o11 =~ s# -o1 # -o11 #;

    $fhCmd->print("#!/bin/bash\n");
    $fhCmd->print("#PBS -o $fileLogOut\n");
    $fhCmd->print("#PBS -e $fileLogErr\n");
    $fhCmd->print("$cmd_o11 > $fileTree_o11\n");
    $fhCmd->print("$cmd1\n");
    $fhCmd->close();

    #
    my($fileJobid) = "$ENV{'MBGD_HOME'}/work/jobid.$$";
    my($cmd) = "$main::CMD_qsub $optQueue $fileCmd";
    print STDERR "DBG :: CMD(domclust) :: $cmd :: " . localtime() . "\n";
    system("$cmd > $fileJobid");

    # JOBID μ
    my($jobid) = getJobidByJobfile($fileJobid);
    unlink($fileJobid);
    $DomClustCommon::JOBID_QSUB = $jobid;

    # socket 𤷤 progress μ
    my($fh_progress) = FileHandle->new(">>$fileProgress");
    my($sock_ref) = $server_ref->accept();
    my($client) = $sock_ref->peername();
    my($client_port, $client_adrs) = unpack_sockaddr_in($client);
    my($client_hostname) = gethostbyaddr($client_adrs, 'AF_INET');
    my($client_ipadrs) = inet_ntoa($client_adrs);

    while(my$line = $sock_ref->getline()) {
        $fh_progress->print($line);
        print STDERR "SOCK :: $line";
    }
    $sock_ref->close();
    $fh_progress->close();

    # PBS  JOB λޤԤ
    waitDomClustQsub($jobid);
    print STDERR "DBG :: CMD(domclust) :: Done. :: " . localtime() . "\n";
    $DomClustCommon::JOBID_QSUB = '';

    #
    unlink($fileLogOut);
    unlink($fileLogErr);
    unlink($fileCmd);

    #
    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);
    load_cluster_score($db, $clustid, $fileScoreOut);
    unlink($fileScoreOut);

    #
    my($cmd2) = "$main::PROG_DOMCLUST_TREE2FLAT $fileTreeOut > $fileListOut";
    print STDERR "DBG :: CMD(tree2flat) :: Start. :: " . localtime() . "\n";
    system("$cmd2");
    print STDERR "DBG :: CMD(tree2flat) :: Done. :: " . localtime() . "\n";

    return;
}

###############################################################################
#
$DomClustCommon::TAB_ID_CLUSTER = '';
sub execDomClust {
    my($clusterID) = shift;
    my($cmdDomClust) = shift;
    my($fileListOut) = shift;
    my($fileStderr) = shift;
    my($fileProgress) = shift;

    $DomClustCommon::TAB_ID_CLUSTER = $clusterID;
    print STDERR "DBG :: cmdDomClust :: $cmdDomClust\n";
    if ($main::USE_QSUB) { # For QSUB
        # sigterm 򤦤ȤνϿ
        setupSigTermFunctionForQsub();

        #
        execDomClustQsub($clusterID, $cmdDomClust, $fileListOut, $fileStderr, $fileProgress);
    }
    else { # For LOCAL
        # sigterm 򤦤ȤνϿ
        setupSigTermFunctionForLocal();

        #
        execDomClustLocal($clusterID, $cmdDomClust, $fileListOut, $fileStderr, $fileProgress);
    }

    return;
}

###############################################################################
# 롣1򡢼Ԥ0֤
sub doDeleteDomClustRes {
    my($db) = shift;
    my($clusterID) = shift;
    my($in) = shift;
    my($out) = shift;

    if(!$clusterID || !$in) {
        return 0;
    }

    # ingroupoutgroupdbΥǡȰפ¹Ԥ
    my $info = &getHeaderInfo($db, $clusterID);
    if(!$info) {
        return 0;
    }
    my $indb = join(',', @{$info->{'ingroup'}});
    my $outdb = join(',', @{$info->{'outgroup'}});
    if(&isSameSpecs($in,$indb) && &isSameSpecs($out,$outdb)) {
        &deleteCacheTable($db, $clusterID);
        return 1;
    } else {
        return 0;
    }
}

###############################################################################
# ʪ郎פƤ뤫ɤǧ
# פʤ1԰פʤ0֤
# ʪϡA,B,C,פΤ褦ʷݻƤΤȤ
sub isSameSpecs {
    my($spA, $spB) = @_;

    my %hashA;
    my $counterA;
    foreach my $a (split/,/, $spA) {
        $hashA{$a}++;
        $counterA++;
    }

    my %hashB;
    my $counterB;
    foreach my $b (split/,/, $spB) {

        if(!exists $hashA{$b}) {
            return 0;
        }
        $hashB{$b}++;
        $counterB++;
    }

    if(scalar(keys(%hashA)) != scalar(keys(%hashB))) {
        return 0;
    }

    return 1;
}

###############################################################################
#
sub printErrMsgExit {
    my($err_no) = shift;          # ȯ顼ֹ
    my($err_msg) = shift;         # ȯ顼å
    my($clust_id) = shift;        # 饹̻

    my($err_code) = '';

    #
    my($package, $filename, $line) = caller();
    $err_code .= sprintf("L%04x", $line);


    #
    print "Content-type: text/plain\n";
    print "\n";

    #
    my(@message_list);
    push(@message_list, sprintf("#FORMAT_VER=%d", $DomClustCommon::VER_DATA_FORMAT));
    push(@message_list, "#STATUS=error");
    push(@message_list, "#STATUS2=$err_msg");
    push(@message_list, "#ERROR_NO=$err_no");
    push(@message_list, "#ERROR_CODE=$err_code");
    if ($clust_id) {
        push(@message_list, "#CLUST_TAB_ID=$clust_id");
    }

    #
    foreach my$msg (@message_list) {
        print $msg, "\n";
    }

    exit(0);
}

###############################################################################
#
sub parse_output_score {
    my($filename) = shift;

    my($score_ref) = {};
    my($ref);
    my($clust_id);

    #
    my($fh) = FileHandle->new("$filename") || die("Can not open $filename($!)");
    while (my$line=$fh->getline()) {
        if ($line =~ /^HomCluster\s+(\d+)/) {
            my($hom_clust_id) = $1;
            $ref = {};
            $score_ref->{'HomCluster'}->{"$hom_clust_id"} = $ref;
        }
        elsif ($line =~ /^Cluster\s+(\d+)/) {
            $clust_id = $1;
            $ref = {};
            $score_ref->{'Cluster'}->{"$clust_id"}->{'SELF'} = $ref;
        }
        elsif ($line =~ /^SubCluster\s+(\d+)/) {
            my($sub_clust_id) = $1;
            $ref = {};
            $score_ref->{'Cluster'}->{"$clust_id"}->{"$sub_clust_id"} = $ref;
        }
        else {
            next;
        }

        $ref->{'SCORE'} = ($line =~ /score\=([\d\.]+)/);
        $ref->{'DIST'}  = ($line =~ /dist\=([\d\.]+)/);
    }
    $fh->close();

    return;
}

###############################################################################
#
sub load_cluster_score {
    my($db) = shift;
    my($tabid) = shift;
    my($filename) = shift;
    my($sql);

    if (!-e $filename) {
        return;
    }

    my($file_tmp) = "$ENV{'MBGD_HOME'}/work/tmp_cluster_score.$$";

    my($fhr) = FileHandle->new("$filename") || die("Can not open $filename($!)");
    my($fhw) = FileHandle->new(">$file_tmp") || die("Can not open $file_tmp($!)");
    my($hom_clust_id);
    my($clust_id);
    my($sub_clust_id);
    while (my$line=$fhr->getline()) {

        if ($line =~ /^HomCluster\s+(\d+)/) {
            $hom_clust_id = $1;
            $clust_id     = '\N';
            $sub_clust_id = '\N';
        }
        elsif ($line =~ /^Cluster\s+(\d+)/) {
            $clust_id = $1;
            $sub_clust_id = '\N';
        }
        elsif ($line =~ /^SubCluster\s+(\d+)/) {
            $sub_clust_id = $1;
        }
        else {
            next;
        }

        #
        my($score) = ($line =~ /score\=([\d\.]+)/);
        $score = '\N' if ($score eq '');

        #
        my($dist)  = ($line =~ /dist\=([\d\.]+)/);
        $dist = '\N' if ($dist eq '');

        #
        $fhw->print(join("\t", $hom_clust_id, $clust_id, $sub_clust_id, $score, $dist), "\n");
    }
    $fhw->close();
    $fhr->close();

    my($tabName) = "cluster_score_$tabid";
    $sql = "create table if not exists $tabName ("
         . "homclustid  int(11) default null,"
         . "clustid     int(11) default null,"
         . "subclustid  int(11) default null,"
         . "score       float default null,"
         . "dist        float default null"
         . ")";

	$db->execute($sql);

    # ȥեΥǡmysqlϿ롣
    $sql = "load data local infile \'$file_tmp\' REPLACE into table $tabName";

	$db->execute($sql);

    # ȥե롣
    unlink($file_tmp);

    return;
}

###############################################################################
#
sub load_taxmapout {
    my($db) = shift;
    my($dumpid) = shift;
    my($tabid) = shift;
    my($filename) = shift;
    my($mapspec) = shift;
    my($sql);

    #
    my($file_tmp) = "$ENV{'MBGD_HOME'}/work/tmp_load_taxmapout.$$";

    my($fhr) = FileHandle->new("$filename") || return;
    my($fhw) = FileHandle->new(">$file_tmp") || die("Can not open $file_tmp($!)");
    my($clust_id);
    while (my$line=$fhr->getline()) {
        $line =~ s#[\r\n]*$##;

        if ($line =~ /^#clustid=(\d+)/) {
            $clust_id = $1;
        }
        else {
            my($spname, $lower, $upper) = split(/\t/, $line);
            $lower = '\N' if ($lower eq 'null');
            $upper = '\N' if ($upper eq 'null');

            $fhw->print(join("\t", $clust_id, $spname, $lower, $upper), "\n");
        }
    }
    $fhw->close();
    $fhr->close();

    #
    my($mapspecid) = add_taxmap_index($db, $dumpid, $tabid, $mapspec);

    #
    my($tabName) = $main::TBL_DOMTAXMAP . '_' . $mapspecid;
    $sql = "create table if not exists $tabName ("
         . "clustid     int(11) default null,"
         . "seqname     varchar(128) not null,"
         . "lower       varchar(128) not null,"
         . "upper       varchar(128) not null,"
         . "key (clustid)"
         . ")";

	$db->execute($sql);

    # ȥեΥǡmysqlϿ롣
    $sql = "load data local infile \'$file_tmp\' REPLACE into table $tabName";
	$db->execute($sql);

    # ȥե롣
    unlink($file_tmp);

    return;
}

###############################################################################
#
sub add_taxmap_index {
    my($db) = shift;
    my($dumpid) = shift;
    my($tabid) = shift;
    my($mapspec) = shift;
    my($sql);

    #
    my($tabName) = $main::TBL_DOMTAXMAPIDX;
    $sql = "create table if not exists $tabName ("
         . "id          int         not null auto_increment,"
         . "udate       timestamp   not null default current_timestamp on update current_timestamp,"
         . "dumpid      varchar(50) not null,"
         . "clustid     varchar(50) not null,"
         . "mapspecid   varchar(50) not null,"
         . "mapspec     varchar(128) not null,"
         . "primary key (id)"
         . ")";
	$db->execute($sql);

    #
    my($pid) = $$;
    my($mapspecid) = time() . '_' . $pid;

    my(@mapspec_list) = split(/,/, $mapspec);
    $mapspec = join(',', sort(@mapspec_list));
    $sql = "insert $tabName (dumpid, clustid, mapspecid, mapspec) values ('$dumpid', '$tabid', '$mapspecid', '$mapspec')";
    $db->execute($sql);

    return $mapspecid;
}

###############################################################################
sub getCmdForDump {
    my($cmd) = shift;

    my(@rm_opt_list) = (
#			 'Ooutgroup\S+',
                         'Ohorizweight\S+',
                         'OoutputScore\S+',
                         'OtaxMapOut\S+',
                         'OtaxMapSpec\S+',
                         'Ometa\S+',
#                         't\S+',
                         'HO', 'H',
                         'p[\d\.]+',
                         'ai[\d\.]+',
                         'ao[\d\.]+',
                         'n\d+',
                         'ne\d+',
                         'c[\d\.]+',
                         'ci[\d\.]+',
                       );

    my($cmd_dump) = $cmd;
    foreach my$opt (@rm_opt_list) {
        $cmd_dump =~ s#\s+\-$opt##;
    }

    return $cmd_dump;
}

###############################################################################
1;#
###############################################################################
