#!/usr/bin/perl -s
package RECOG::MBGD::ClusterTable::Writer::html;
###############################################################################
# ̾
#     RECOG::MBGD::ClusterTable::Writer::html.pm
# 
#     MBGD::ClusterTableݻǡHTMLTABLEѤɽ
#     Ϥ롣
# 
#     ܥ⥸塼 ClusterTable::Writer Υ֥饹ȤƼƤ뤬
#     ܥ⥸塼쥯ȤѤ뤳ȤꤵƤʤ
#     ̥饹{ format => "html" } Ȼꤷƥ󥹥󥹤뤳Ȥ
#     Ǥ롣
#     
# ѿ
#     'FileHandle'
# ᥽åɰ
#     new()
#     write()
# 
#
###############################################################################
use FileHandle;
use CGI qw/ :standard start_table end_table /;
use RECOG::MBGD::ClusterTable::Writer;

use MBGD;
use RECOG;
@ISA = ( 'RECOG::MBGD::ClusterTable::Writer' );

###############################################################################
# ̾
#     new()
# 
#     󥹥ȥ饯
# 
#     $that  : 饹̾(⤷ϥ󥹥󥹤Υե)
# 
#     󥹥󥹤ؤΥե
# 
#
# 
#
sub new {
    my $that = shift;
##    my %args  = @_;

    # $that ե󥹤ʤ顢ѥå̾롣
    my $class = ref($that) || $that;

    my $self = {};
    bless $self, $class;

    return $self;
}

###############################################################################
# ̾
#     write()
# 
#     饹ơ֥HTMLǽϤ롣
# 
#     $self   : 󥹥󥹤Υե
#     $db     : ǡ١ϥɥ
#     $igrp   : ingroup ˳ʪ̾Υꥹ (ꥹȽ˽äƽ)
#     $ogrp   : outgroup ˳ʪ̾Υꥹ(ꥹȽ˽äƽ)
#     $format : ϥեޥå complete, boolean, count Τ줫
#     $clusterID : 饹ID
#
# 
#     󥹥󥹤ؤΥե
# 
#     ClusterTableΥѿ'Table'ι¤˽äɽϤ롣
#     ʪνϽϡ$igrp, $ogrp ǽ˽
# 
#
sub write {
	my $self = shift;
	my $db = shift;
	my $igrp = shift;
	my $ogrp = shift;
	my $format = shift;
	my $clusterID = shift;

    my $fh = $self->{'FileHandle'};

    print $fh start_table({-border => 1});

    # ơ֥إåϤ롣
    # outgroup ¸ߤ
    if(scalar(@$ogrp) > 0) {
        print $fh Tr({-align => 'center', -valign => 'middle'},
                     th({-rowspan => 2}, ['Super Cluster ID', 'Super Cluster Gene', 'Super Cluster Func',
                                          'Cluster ID', 'Cluster Gene', 'Cluster Func']),
                     th({-colspan => scalar(@$igrp)}, ['ingroup']),
                     th({-colspan => scalar(@$ogrp)}, ['outgroup']));
        print $fh Tr({-align => 'center'}, th({}, [@$igrp, @$ogrp]));
    }
    # outgroup ¸ߤʤ
    else {
        print $fh Tr({-align => 'center', -valign => 'middle'},
                     th({}, ['Super Cluster ID', 'Super Cluster Gene', 'Super Cluster Func',
                             'Cluster ID', 'Cluster Gene', 'Cluster Func',
                             @$igrp]));
    }
    print $fh "\n";
#---------------------------------------إåλ
    # 饹֥饹˥ꥹȤϤ롣
	my $tablegene = $main::TBL_DOMRESULT . "_" . $clusterID;
	my $tablefunc = $main::TBL_DOMFUNC . "_" . $clusterID;

#t1.饹򥫥Ȥб륯饹groupǡݻ
#t2.֥饹ΰ
#t3.֥饹func
#t4.饹ΰ
	my $sql = "select t1.clustid, t4.name, t5.name, t1.subclustid, t2.name, t3.name, t1.name from $tablegene t1 inner join ( $tablefunc t2 inner join ( $tablefunc t3 inner join ( $tablefunc t4 inner join $tablefunc t5 on t4.clustid=t5.clustid and t4.subclustid=0 and t5.subclustid=0 and t4.dbname=\'gene\' and t5.dbname=\'mbgd\') on t3.clustid=t5.clustid and t3.dbname=\'mbgd\') on t2.clustid=t3.clustid and t2.subclustid=t3.subclustid and t2.dbname=\'gene\') on t1.clustid=t2.clustid and t1.subclustid=t2.subclustid";

	my $dbh = $db->execute($sql);

	my $name_gene;
	my $name_func;
 
	while(my $line = $dbh->fetch()) {
		my($cid, $cgene, $cfunc, $sid, $sgene, $sfunc, $name) = @$line;
		
		# ORF̾μ
		my(@sub, @out);
		my(@outgrp, @trlist);
		my $trlist={};
		my $sublist={};
		if($name=~/(.*)\sOutgroup\s(.*)/) {
			@sub = split/ /, $1;
			@out = split/ /, $2;
			$sublist = $self->transform_sort(\@sub);
			$trlist = $self->transform_sort(\@out);
		}
		else {
			@sub = split/ /, $name;
			$sublist = $self->transform_sort(\@sub);
		}

		# ꤷʪ¤ؤ
		# outgroup
		for(my $k = 0; $k < scalar(@$ogrp); $k++) {
            my $org   = $ogrp->[$k];
			my @glist = keys %{$trlist->{$org}} if(exists $trlist->{$org});
			push(@outgrp, join(br,$self->transform($format, @glist)));
	    }

		# ingroup
		for(my $k = 0; $k < scalar(@$igrp); $k++) {
			my $org   = $igrp->[$k];
			my @glist = keys %{$sublist->{$org}} if(exists $sublist->{$org});
			push(@trlist,join(br, $self->transform($format, @glist)));
		}

		# 
		print $fh Tr({-align => 'center', -valign => 'top'},
					 td({}, [$cid,$cgene,$cfunc]),
					 td({}, [$sid,$sgene,$sfunc,@trlist]),
					 ($i == 0 && scalar(@$ogrp > 0) ? td({}, [@outgrp]) : undef));
	}
    print $fh end_table;
    print $fh "\n";
}

##############################################################################
1; #
##############################################################################
