#!/usr/local/bin/perl -s

###############################################################################
#
###############################################################################
use DirHandle;
use File::Basename;
use File::Path;
require "MBGD_Conf.pl";
require "libMBGDaxes.pl";

###############################################################################
# ơ֥ڤؤ
#    TAB_NAM        ---> TAB_NAM$oldExt
#    TAB_NAM$newExt ---> TAB_NAM
#
# оݤȤʤơ֥ϡʲ̤
#     genome
#     chromosome
#     gene
#     homology
#     protmotif
#
###############################################################################
@ChangeTables = ('genome', 'chromosome', 'gene', 'homology', 'protmotif');
@ChangeClstTables = ('cluster_default', 'clusttab_default');
@ChangeFiles  = ("bldb", "bldp", "class", "sptit", "dbtab",
		"taball.domclust", "tax");
###############################################################################

sub ChangeTabs {
    my($dbname, $oldExt, $newExt, @tabList) = @_;
    my($tabname);
    my($nameold);
    my($namenew);

    if (scalar(@tabList) == 0) {
        @tabList = @ChangeTables;
    }

    foreach $tabname (@tabList) {
        $nameold = "${tabname}";
        $namenew = "${tabname}${oldExt}";
        if ($main::DEBUG) {
            print STDERR "DBG :: rename table($dbname, $nameold, $namenew)\n";
        }
        else {
            &main::MBGD_RenameTable($dbname, $nameold, $namenew);
        }

        $nameold = "${tabname}${newExt}";
        $namenew = "${tabname}";
        if ($main::DEBUG) {
            print STDERR "DBG :: rename table($dbname, $nameold, $namenew)\n";
        }
        else {
            &main::MBGD_RenameTable($dbname, $nameold, $namenew);
        }
    }
}

###############################################################################
1;#
###############################################################################
