#!/usr/local/bin/perl -s

###############################################################################
use MBGD;
require "MBGD_Conf.pl";

###############################################################################
# for homology table
sub main::MBGD_LoadDataInfileHomology {
    my($dbname, $filename) = @_;

    # MySQL  DB Ȥä
    my($tab, $opt);
    my($col);
    my($loadMode) = "REPLACE";       # Ͽ
    my($db);
    my($sql);
    my($sth);
    my($cmd);

    #
    $db = MBGD::DB->new($dbname);

    my($tabname) = "Homology";
    my($lcname) = lc($tabname);
    if ($db->exist_table($lcname) != 1) {
        # create table ¹
        $opt = { 'tablename' => $lcname,
                 'create'    => 1 };
        MBGD::DBTable->new($db, 'Homology', $opt);
    }

    #
    $tab = "$lcname";
    $col = "sp1,name1,spname1,from1,to1,sp2,name2,spname2,from2,to2,ident,eval,pam,score";
    $sql = "load data local infile '$filename' $loadMode into table $tab ($col)";
    print STDERR "SQL :: $sql\n" if ($DEBUG);

    # SQL ¹
    $sth = $db->execute("$sql");
    if (not $sth) {
        &MBGD_DbAccessError($sth, $sql);
        return undef();
    }

    # λ
    $sth->finish();

    return;
}

###############################################################################
# for protmotif table
sub main::MBGD_LoadDataInfileProtmotif {
    my($dbname, $filename) = @_;

    # MySQL  DB Ȥä
    my($tab, $opt);
    my($col);
    my($loadMode) = "REPLACE";       # Ͽ
    my($db);
    my($sql);
    my($sth);
    my($cmd);

    # DB ³
    $db = MBGD::DB->new($dbname);

    my($tabname) = "ProtMotif";
    my($lcname) = lc($tabname);
    if ($db->exist_table($lcname) != 1) {
        # create table ¹
        $opt = { 'tablename' => $lcname,
                 'create'    => 1 };
        MBGD::DBTable->new($db, 'ProtMotif', $opt);
    }

    #
    $tab = "$lcname";
    $col = "sp,name,from1,to1,motlib,motid,motname,program,from2,to2,score,eval,descr";
    $sql = "load data local infile '$filename' $loadMode into table $tab ($col)";
    print STDERR "SQL :: $sql\n" if ($DEBUG);

    # SQL ¹
    $sth = $db->execute("$sql");
    if (not $sth) {
        &MBGD_DbAccessError($sth, $sql);
        return undef();
    }

    # λ
    $sth->finish();

    return;
}

###############################################################################
1;#
###############################################################################
