#!/usr/local/bin/perl -s

###############################################################################
require "libCheckPoint.pl";

###############################################################################
#
sub doProcList {
    my(@procList) = @_;
    my($proc);
    my($procTitle, $procName, $procOpt, $procIn, $procOut, $procNoexit);
    my($cmd);
    my($ret);

    foreach $proc (@procList) {
        $procTitle  = $proc->{'title'};
        $procName   = $proc->{'procname'};
        $procOpt    = $proc->{'opt'};
        $procIn     = $proc->{'infile'};
        $procOut    = $proc->{'outfile'};
        $procNoexit = $proc->{'noexit'};

        $cmd = "$procName $procOpt";
        $cmd .= " < $procIn" if ($procIn);
        if ($procOut) {
#            unlink("$procOut") if (-e "$procOut");
            $cmd .= " > $procOut";
        }
        $ret = &procCheckPoint("$procTitle", $cmd);
        if (! $procNoexit) {
            die "$procTitle terminated with return code $ret\n" if ($ret);
        }
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    exit;
}

###############################################################################
1;#
###############################################################################
