#!/usr/bin/perl -s
package main;
################################################################################
# translation table
# http://www.ncbi.nlm.nih.gov/Taxonomy/Utils/wprintgc.cgi
################################################################################
# The Standard Code (transl_table=1)
                                    #  ACGTRYSWKMBDHVX
    %codon_table01 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "X*Y*Y*YXXXXXXXXX",
                            "TG"  => "X*CWCXCXXXXXXXXX",
                            "CT"  => "XLLLLLLLLLLLLLLL",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XIIMIXIXIXIXXIXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XKNKNKNXXXXXXXXX",
                            "AG"  => "XRSRSRSXXXXXXXXX",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext01 =  ( "YTA" => "L",
                            "YTG" => "L",
                            "YTR" => "L",
                            "TRA" => "*",
                            "MGA" => "R",
                            "MGG" => "R",
                            "MGR" => "R");
    %codon_start01 =      ( "TT"  => "0001000000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0001000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0001000000000000",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0000000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext01 =  ( "HTG" => "1",
                            "YTG" => "1",
                            "MTG" => "1",
                            "WTG" => "1");


################################################################################
# The Vertebrate Mitochondrial Code (transl_table=2)
                                    #  ACGTRYSWKMBDHVX
    %codon_table02 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "X*Y*Y*YXXXXXXXXX",
                            "TG"  => "XWCWCWCXXXXXXXXX",
                            "CT"  => "XLLLLLLLLLLLLLLL",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XMIMIMIXXXXXXXXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XKNKNKNXXXXXXXXX",
                            "AG"  => "X*S*S*SXXXXXXXXX",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext02 =  ( "YTA" => "L",
                            "YTG" => "L",
                            "YTR" => "L");
    %codon_start02 =      ( "TT"  => "0000000000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0000000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0111111111111111",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0001000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext02 =  ( "RTG" => "1");


################################################################################
# The Yeast Mitochondrial Code (transl_table=3)
                                    #  ACGTRYSWKMBDHVX
    %codon_table03 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "X*Y*Y*YXXXXXXXXX",
                            "TG"  => "XWCWCWCXXXXXXXXX",
                            "CT"  => "XTTTTTTTTTTTTTTT",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XMIMIMIXIXIXXIXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XKNKNKNXXXXXXXXX",
                            "AG"  => "XRSRSRSXXXXXXXXX",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext03 =  ( "MGA" => "R",
                            "MGG" => "R",
                            "MGR" => "R");
    %codon_start03 =      ( "TT"  => "0000000000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0000000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0001000000000000",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0000000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext03 =  ();


################################################################################
# The Mold, Protozoan, and Coelenterate Mitochondrial Code and the
# Mycoplasma/Spiroplasma Code (transl_table=4)
                                    #  ACGTRYSWKMBDHVX
    %codon_table04 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "X*Y*Y*YXXXXXXXXX",
                            "TG"  => "XWCWCWCXXXXXXXXX",
                            "CT"  => "XLLLLLLLLLLLLLLL",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XIIMIXIXIXIXXIXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XKNKNKNXXXXXXXXX",
                            "AG"  => "XRSRSRSXXXXXXXXX",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext04 =  ( "YTA" => "L",
                            "YTG" => "L",
                            "YTR" => "L",
                            "MGA" => "R",
                            "MGG" => "R",
                            "MGR" => "R");
    %codon_start04 =      ( "TT"  => "0101010000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0001000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0111111111111111",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0001000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext04 =  ( "TTR" => "1",
                            "RTG" => "1",
                            "YTG" => "1",
                            "STG" => "1",
                            "WTG" => "1",
                            "KTG" => "1",
                            "MTG" => "1",
                            "BTG" => "1",
                            "DTG" => "1",
                            "HTG" => "1",
                            "VTG" => "1",
                            "XTG" => "1");


################################################################################
# The Invertebrate Mitochondrial Code (transl_table=5)
                                    #  ACGTRYSWKMBDHVX
    %codon_table05 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "X*Y*Y*YXXXXXXXXX",
                            "TG"  => "XWCWCWCXXXXXXXXX",
                            "CT"  => "XLLLLLLLLLLLLLLL",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XMIMIMIXIXIXXIXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XKNKNKNXXXXXXXXX",
                            "AG"  => "XSSSSSSSSSSSSSSS",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext05 =  ( "YTA" => "L",
                            "YTG" => "L",
                            "YTR" => "L");
    %codon_start05 =      ( "TT"  => "0001000000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0000000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0111111111111111",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0001000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext05 =  ( "DTG" => "1",
                            "WTG" => "1",
                            "RTG" => "1",
                            "KTG" => "1");


################################################################################
# The Ciliate, Dasycladacean and Hexamita Nuclear Code (transl_table=6)
                                    #  ACGTRYSWKMBDHVX
    %codon_table06 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "XQYQYQYXXXXXXXXX",
                            "TG"  => "X*CWCXCXXXXXXXXX",
                            "CT"  => "XLLLLLLLLLLLLLLL",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XIIMIXIXIXIXXIXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XKNKNKNXXXXXXXXX",
                            "AG"  => "XRSRSRSXXXXXXXXX",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext06 =  ( "YTA" => "L",
                            "YTG" => "L",
                            "YTR" => "L",
                            "MGA" => "R",
                            "MGG" => "R",
                            "MGR" => "R",
                            "YAA" => "Q",
                            "YAG" => "Q",
                            "YAR" => "Q");
    %codon_start06 =      ( "TT"  => "0000000000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0000000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0001000000000000",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0000000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext06 =  ();


################################################################################
# Table 7 has been deleted
                                    #  ACGTRYSWKMBDHVX
    %codon_table07 =      ();
    %codon_table_ext07 =  ();
    %codon_start07 =      ();
    %codon_start_ext07 =  ();


################################################################################
# Table 8 has been deleted
                                    #  ACGTRYSWKMBDHVX
    %codon_table08 =      ();
    %codon_table_ext08 =  ();
    %codon_start08 =      ();
    %codon_start_ext08 =  ();


################################################################################
# The Echinoderm Mitochondrial Code (transl_table=9)
                                    #  ACGTRYSWKMBDHVX
    %codon_table09 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "X*Y*Y*YXXXXXXXXX",
                            "TG"  => "XWCWCWCXXXXXXXXX",
                            "CT"  => "XLLLLLLLLLLLLLLL",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XIIMIXIXIXIXXIXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XNNKNXNXNXNXXNXX",
                            "AG"  => "XSSSSSSSSSSSSSSS",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext09 =  ( "YTA" => "L",
                            "YTG" => "L",
                            "YTR" => "L");
    %codon_start09 =      ( "TT"  => "0000000000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0000000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0001000000000000",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0000000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext09 =  ();


################################################################################
# The Euplotid Nuclear Code (transl_table=10)
                                    #  ACGTRYSWKMBDHVX
    %codon_table10 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "X*Y*Y*YXXXXXXXXX",
                            "TG"  => "XCCWCXCXCXCXXCXX",
                            "CT"  => "XLLLLLLLLLLLLLLL",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XIIMIXIXIXIXXIXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XKNKNKNXXXXXXXXX",
                            "AG"  => "XRSRSRSXXXXXXXXX",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext10 =  ( "YTA" => "L",
                            "YTG" => "L",
                            "YTR" => "L",
                            "MGA" => "R",
                            "MGG" => "R",
                            "MGR" => "R");
    %codon_start10 =      ( "TT"  => "0000000000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0000000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0001000000000000",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0000000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext10 =  ();


################################################################################
# The Bacterial "Code" (transl_table=11)
                                    #  ACGTRYSWKMBDHVX
    %codon_table11 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "X*Y*Y*YXXXXXXXXX",
                            "TG"  => "X*CWCXCXXXXXXXXX",
                            "CT"  => "XLLLLLLLLLLLLLLL",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XIIMIXIXIXIXXIXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XKNKNKNXXXXXXXXX",
                            "AG"  => "XRSRSRSXXXXXXXXX",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext11 =  ( "YTA" => "L",
                            "YTG" => "L",
                            "YTR" => "L",
                            "TRA" => "*",
                            "MGA" => "R",
                            "MGG" => "R",
                            "MGR" => "R");
    %codon_start11 =      ( "TT"  => "0001000000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0001000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0111111111111111",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0001000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext11 =  ( "RTG" => "1",
                            "YTG" => "1",
                            "STG" => "1",
                            "WTG" => "1",
                            "KTG" => "1",
                            "MTG" => "1",
                            "BTG" => "1",
                            "DTG" => "1",
                            "HTG" => "1",
                            "VTG" => "1",
                            "XTG" => "1");


################################################################################
# The Alternative Yeast Nuclear Code (transl_table=12)
                                    #  ACGTRYSWKMBDHVX
    %codon_table12 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "X*Y*Y*YXXXXXXXXX",
                            "TG"  => "X*CWCXCXXXXXXXXX",
                            "CT"  => "XLLSLXLXLXLXXLXL",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XIIMIXIXIXIXXIXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XKNKNKNXXXXXXXXX",
                            "AG"  => "XRSRSRSXXXXXXXXX",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext12 =  ( "YTA" => "L",
                            "YTG" => "L",
                            "YTR" => "L",
                            "TRA" => "*");
    %codon_start12 =      ( "TT"  => "0000000000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0001000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0001000000000000",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0000000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext12 =  ( "MTG" => "1");


################################################################################
# The Ascidian Mitochondrial Code (transl_table=13)
                                    #  ACGTRYSWKMBDHVX
    %codon_table13 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "X*Y*Y*YXXXXXXXXX",
                            "TG"  => "XWCWCWCXXXXXXXXX",
                            "CT"  => "XLLLLLLLLLLLLLLL",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XMIMIMIXIXIXXIXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XKNKNKNXXXXXXXXX",
                            "AG"  => "XGSGSGSXXXXXXXXX",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext13 =  ( "YTA" => "L",
                            "YTG" => "L",
                            "YTR" => "L",
                            "RGA" => "G",
                            "RGG" => "G",
                            "RGR" => "G");
    %codon_start13 =      ( "TT"  => "0000000000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0000000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0001000000000000",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0000000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext13 =  ();


################################################################################
# The Flatworm Mitochondrial Code (transl_table=14)
                                    #  ACGTRYSWKMBDHVX
    %codon_table14 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "XYY*YXYXYXYXXYXX",
                            "TG"  => "XWCWCWCXXXXXXXXX",
                            "CT"  => "XLLLLLLLLLLLLLLL",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XIIMIXIXIXIXXIXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XNNKNXNXNXNXXNXX",
                            "AG"  => "XSSSSSSSSSSSSSSS",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext14 =  ( "YTA" => "L",
                            "YTG" => "L",
                            "YTR" => "L");
    %codon_start14 =      ( "TT"  => "0000000000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0000000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0001000000000000",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0000000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext14 =  ();


################################################################################
# Blepharisma Nuclear Code (transl_table=15)
                                    #  ACGTRYSWKMBDHVX
    %codon_table15 =      ( "TT"  => "XLFLFLFXXXXXXXXX",
                            "TC"  => "XSSSSSSSSSSSSSSS",
                            "TA"  => "X*YQYXYXXXXXXXXX",
                            "TG"  => "X*CWCXCXXXXXXXXX",
                            "CT"  => "XLLLLLLLLLLLLLLL",
                            "CC"  => "XPPPPPPPPPPPPPPP",
                            "CA"  => "XQHQHQHXXXXXXXXX",
                            "CG"  => "XRRRRRRRRRRRRRRR",
                            "AT"  => "XIIMIXIXIXIXXIXX",
                            "AC"  => "XTTTTTTTTTTTTTTT",
                            "AA"  => "XKNKNKNXXXXXXXXX",
                            "AG"  => "XRSRSRSXXXXXXXXX",
                            "GT"  => "XVVVVVVVVVVVVVVV",
                            "GC"  => "XAAAAAAAAAAAAAAA",
                            "GA"  => "XEDEDEDXXXXXXXXX",
                            "GG"  => "XGGGGGGGGGGGGGGG",);
    %codon_table_ext15 =  ( "YTA" => "L",
                            "YTG" => "L",
                            "YTR" => "L",
                            "TRA" => "*",
                            "YAG" => "Q",
                            "MGA" => "R",
                            "MGG" => "R",
                            "MGR" => "R");
    %codon_start15 =      ( "TT"  => "0000000000000000",
                            "TC"  => "0000000000000000",
                            "TA"  => "0000000000000000",
                            "TG"  => "0000000000000000",
                            "CT"  => "0000000000000000",
                            "CC"  => "0000000000000000",
                            "CA"  => "0000000000000000",
                            "CG"  => "0000000000000000",
                            "AT"  => "0001000000000000",
                            "AC"  => "0000000000000000",
                            "AA"  => "0000000000000000",
                            "AG"  => "0000000000000000",
                            "GT"  => "0000000000000000",
                            "GC"  => "0000000000000000",
                            "GA"  => "0000000000000000",
                            "GG"  => "0000000000000000",);
    %codon_start_ext15 =  ();


################################################################################
    @conv_table = ( [ \%codon_table01, \%codon_table_ext01, \%codon_start01, \%codon_start_ext01 ],
                    [ \%codon_table02, \%codon_table_ext02, \%codon_start02, \%codon_start_ext02 ],
                    [ \%codon_table03, \%codon_table_ext03, \%codon_start03, \%codon_start_ext03 ],
                    [ \%codon_table04, \%codon_table_ext04, \%codon_start04, \%codon_start_ext04 ],
                    [ \%codon_table05, \%codon_table_ext05, \%codon_start05, \%codon_start_ext05 ],
                    [ \%codon_table06, \%codon_table_ext06, \%codon_start06, \%codon_start_ext06 ],
                    [ \%codon_table07, \%codon_table_ext07, \%codon_start07, \%codon_start_ext07 ],
                    [ \%codon_table08, \%codon_table_ext08, \%codon_start08, \%codon_start_ext08 ],
                    [ \%codon_table09, \%codon_table_ext09, \%codon_start09, \%codon_start_ext09 ],
                    [ \%codon_table10, \%codon_table_ext10, \%codon_start10, \%codon_start_ext10 ],
                    [ \%codon_table11, \%codon_table_ext11, \%codon_start11, \%codon_start_ext11 ],
                    [ \%codon_table12, \%codon_table_ext12, \%codon_start12, \%codon_start_ext12 ],
                    [ \%codon_table13, \%codon_table_ext13, \%codon_start13, \%codon_start_ext13 ],
                    [ \%codon_table14, \%codon_table_ext14, \%codon_start14, \%codon_start_ext14 ],
                    [ \%codon_table15, \%codon_table_ext15, \%codon_start15, \%codon_start_ext15 ]);


################################################################################
    %tcag_table =      (  # "?"   =>  0,
                            "A"   =>  1,
                            "C"   =>  2,
                            "G"   =>  3,
                            "T"   =>  4,
                            "R"   =>  5,
                            "Y"   =>  6,
                            "S"   =>  7,
                            "W"   =>  8,
                            "K"   =>  9,
                            "M"   => 10,
                            "B"   => 11,
                            "D"   => 12,
                            "H"   => 13,
                            "V"   => 14,
                            "X"   => 15,);


###############################################################################
#                                                                             #
# Name          : na2aa                                                       #
#                                                                             #
# Synopsis      : &na2aa($org_sequence, $frame, $tableno);                    #
#                     $org_sequence : only nucleic acid code                  #
#                     $frame        : 1, 2 or 3                               #
#                     $tableno        : translation table number              #
#                                                                             #
# Retuen Value  : only protein code                                           #
#                                                                             #
###############################################################################
sub na2aa
{
    my($seqdata, $frame, $tableno) = @_;
    my($code, $cod2, $cod3);
    my($protein);
    my($wk);
    my($st);
    my($i);

    $seqdata =~ s/[\s]+//g;
    $seqdata =~ tr/a-z/A-Z/;
    $seqdata =~ tr/UN\./TXX/;
    if ($seqdata =~ /[0-9]/) {
        print STDERR "Warning : Nucleic acid sequence contein numerical code.\n";
        $seqdata =~ s/[0-9]//g;
    }

    if ($seqdata =~ /[^ACGTRYSWKMBDHVX]/) {
        print STDERR "Error : Nucleic acid sequence contein illegal code.\n";
        $_[$#_] = "";
        return();
    }

    #
    $frame = 1 if (!$frame);
    if (($frame < 1) || (3 < $frame)) {
        print STDERR "Error : Out of Range(Frame)$frame\n";
        $_[$#_] = "";
        return('');
    }

    #
    $tableno = 1 if (!$tableno);
    if (($tableno < 1) || (15 < $tableno)) {
        print STDERR "Error : Out of Range(translation table No)$tableno\n";
        $_[$#_] = "";
        return('');
    }
    if (($tableno == 7) || ($tableno == 8)) {
        print STDERR "Error : Translation table #$tableno has been deleted.\n";
        $_[$#_] = "";
        return('');
    }

    $seqdata = substr($seqdata, $frame - 1);
    $seqdata = substr($seqdata, 0, int(length($seqdata) / 3) * 3);

    $protein = "";
    for($i = 0; $i < length($seqdata); $i += 3) {
        $code = substr($seqdata, $i, 3);
        $cod2 = $code;
        $cod3 = chop($cod2);

        # ˻򥢥ߥλѴ
        $wk = substr($conv_table[$tableno - 1]->[0]->{"$cod2"}, $tcag_table{"$cod3"}, 1);
        $wk = $conv_table[$tableno - 1]->[1]->{$code} if ($wk eq "");
        $wk = "X" if ($wk eq "");

        # ȥɥȽʥȥɥξ硢'M'֤
        $st = substr($conv_table[$tableno - 1]->[2]->{"$cod2"}, $tcag_table{"$cod3"}, 1);
        $st = $conv_table[$tableno - 1]->[3]->{$code} if ($st eq "");
        $st = 0 if ($st eq "");
        $wk = "M" if (($i == 0) && ($st == 1));

        $protein .= $wk;
    }

    return($protein);
}
###############################################################################
sub nt2aa {
    return na2aa(@_);
}
###############################################################################

###############################################################################
# execute convert (except 'require' this file)
###############################################################################
if ($0 eq __FILE__) {
    $frame = 1 if (! $frame);
    $table = 1 if (! $table);

    while(<>) {
        next if (/^>/);
        chop();
        $sequence .= $_;
    }
    print &na2aa($sequence, $frame, $table), "\n";
}
###############################################################################
1;                                                # Return TRUE Value
###############################################################################
