#!/usr/bin/perl -w
use strict;
use File::Basename;
use Getopt::Std;
my $PROGRAM = basename $0;
my $USAGE=
"Usage: $PROGRAM [OPTION] CLUSTER_FILE
-e GAP_EXT
-o GAP_OPEN

Modify domain organizations: move_boundary, create_boundary

Intermediate output files:
CLUSTER_FILE.link(|_eval|_eval.score.jobs|_eval.score.jobs.check)
CLUSTER_FILE.move_test(|.jobs|.jobs.check|.score.jobs|.score.jobs.check|.summary)
CLUSTER_FILE.move.create_test(|.jobs|.jobs.check|.score.jobs|.score.jobs.check|.summary)

Final output files:
CLUSTER_FILE.move(|.log)
CLUSTER_FILE.move.create(|.log)
";

my %OPT;
getopts('t:e:o:', \%OPT);

### Settings ###
my $OPTION = "";
if (defined $OPT{e}) {
    $OPTION .= " -e $OPT{e}";
}
if (defined $OPT{o}) {
    $OPTION .= " -o $OPT{o}";
}

my $SCORE = "dom_score_c";
# $SCORE .= " -r"; # align by region
$SCORE .= $OPTION;

my $MOVE_BOUNDARY = "dom_move_boundary";
# $MOVE_BOUNDARY .= " -r"; # align by region
$MOVE_BOUNDARY .= $OPTION;

my $CREATE_BOUNDARY = "dom_create_boundary";
# $CREATE_BOUNDARY .= " -r"; # align by region
$CREATE_BOUNDARY .= $OPTION;

### Main ###
if (@ARGV == 0) {
    print STDERR $USAGE;
    exit 1;
}
my ($CLUSTER) = @ARGV;

my $GET_CLUSTER = "cat $CLUSTER.link | ignore_clusters.pl cluster.to_ignore";

### prepare ###
if (! -f "$CLUSTER.link") {
    system "cat $CLUSTER | dom_network -l > $CLUSTER.link";
}

### move boundary ###
if (! -f "$CLUSTER.move") {
    system "$GET_CLUSTER | sge_script.pl -R -i $CLUSTER -o $CLUSTER.link_eval -p score '$SCORE'";
    system "$GET_CLUSTER | sge_script.pl -R -i $CLUSTER -o $CLUSTER.move_test '$MOVE_BOUNDARY'";
    system "$GET_CLUSTER | sge_script.pl -R -i $CLUSTER.move_test -o $CLUSTER.move_test -p score '$SCORE'";
    system "$GET_CLUSTER | summarize_score.pl -i $CLUSTER.link_eval/score. -o $CLUSTER.move_test/score. > $CLUSTER.move_test.summary";
    system "cat $CLUSTER.move_test.summary | select_positive.pl -f 4 | sort -k4,4gr > $CLUSTER.move_test.to_move";
    system "cat $CLUSTER.move_test.to_move | modify_stepwise -i $CLUSTER -o $CLUSTER.move_test > $CLUSTER.move 2> $CLUSTER.move.log";
    system "cat $CLUSTER.move.log | grep modified_to >  $CLUSTER.moved";
}

### create boundary ###
if (! -f "$CLUSTER.move.create") {
    system "cat $CLUSTER.moved | cut -f1 | sge_boundary.pl -R -i $CLUSTER.move_test -o $CLUSTER.move.create_test '$CREATE_BOUNDARY'";
    system "cat $CLUSTER.moved | cut -f1 | sge_script.pl -R -i $CLUSTER.move.create_test -o $CLUSTER.move.create_test -p score '$SCORE'";
    system "cat $CLUSTER.moved | cut -f1 | summarize_score.pl -i $CLUSTER.move_test/score. -o $CLUSTER.move.create_test/score. > $CLUSTER.move.create_test.summary";
    system "cat $CLUSTER.move.create_test.summary | select_positive.pl -f 4 | sort -k4,4gr > $CLUSTER.move.create_test.to_create";
    system "cat $CLUSTER.move.create_test.to_create | modify_stepwise -i $CLUSTER.move -o $CLUSTER.move.create_test > $CLUSTER.move.create 2> $CLUSTER.move.create.log";
}
