#!/usr/bin/perl -w
use strict;
use File::Basename;
use Getopt::Std;
my $PROGRAM = basename $0;
my $USAGE=
"Usage: $PROGRAM [OPTION] CLUSTER_FILE SEQ_DB &
        $PROGRAM COMMAND
-t THRESHOLD
-e GAP_EXT
-o GAP_OPEN
";

if (@ARGV == 1) {
    system "$ARGV[0]";
    exit;
}

my %OPT;
getopts('t:e:o:R', \%OPT);

my $T = "";
my $E = "";
my $O = "";
if ($OPT{t}) {
    $T = "-t $OPT{t}";
}
if ($OPT{e}) {
    $E = "-e $OPT{e}";
}
if ($OPT{o}) {
    $O = "-o $OPT{o}";
}

if (@ARGV != 2) {
    print STDERR $USAGE;
    exit 1;
}
my ($INPUT_FILE, $SEQ_DB) = @ARGV;
if (! -f $INPUT_FILE) {
    die $USAGE;
}

### Settings ###
my $LOG_FILE = "domrefine.log";

$ENV{DOMREFINE_SEQ_DB} = $SEQ_DB;

my $DIR = `pwd`;
chomp($DIR);
$ENV{DOMREFINE_CACHE} = "$DIR/cache";
$ENV{DOMREFINE_QSUB_TMP} = "$DIR/sge";
$ENV{DOMREFINE_TMP} = "$DIR/tmp";

system "env | grep '^DOMREFINE_' | sort >> $LOG_FILE";

### Preparation ###
system "echo start >> $LOG_FILE";
system "date >> $LOG_FILE";
if (! -e "cluster") {
    system "echo preparing input cluster >> $LOG_FILE";
    if ($INPUT_FILE eq "cluster") {
    } elsif ($INPUT_FILE =~ /\.o0$/) {
	system "cat $INPUT_FILE | domclust_to_tsv.pl > cluster";
    } elsif ($INPUT_FILE =~ /\.dclst$/) {
	system "cat $INPUT_FILE | dclst_to_files.pl";
    } else {
	system "ln -s $INPUT_FILE cluster";
    }
}
if (! -e $ENV{DOMREFINE_CACHE}) {
    system "create_cache.pl 2>> $LOG_FILE";
}
if (! -e $ENV{DOMREFINE_QSUB_TMP}) {
    system "echo creating $ENV{DOMREFINE_QSUB_TMP} >> $LOG_FILE";
    system "mkdir $ENV{DOMREFINE_QSUB_TMP}";
}
if (! -e $ENV{DOMREFINE_TMP}) {
    system "mkdir $ENV{DOMREFINE_TMP}";
}

### Main ###
if (! -f "cluster.merge") {
    system "echo merge >> $LOG_FILE";
    system "date >> $LOG_FILE";
    system "merge.pl -R1 $T $E $O cluster";
}
if (! -f "cluster.merge.merge_divide") {
    system "echo merge_divide_tree >> $LOG_FILE";
    system "date >> $LOG_FILE";
    system "merge_divide.pl $E $O cluster.merge";
}
if (! -f "cluster.merge.merge_divide.move.create") {
    system "echo boundary >> $LOG_FILE";
    system "date >> $LOG_FILE";
    system "boundary.pl $E $O cluster.merge.merge_divide";
}
if (! -f "cluster.merge.merge_divide.move.create.divide") {
    system "echo divide_tree >> $LOG_FILE";
    system "date >> $LOG_FILE";
    system "divide.pl -1 cluster.merge.merge_divide.move.create";
}

### Post-processing ###
system "echo post-processing >> $LOG_FILE";
system "date >> $LOG_FILE";
if (-f "cluster.merge.merge_divide.move.create.divide" and ! -f "cluster.domrefine.o0") {
    system "cat cluster.merge.merge_divide.move.create.divide | dom_renumber -c > cluster.domrefine";
    system "cat cluster.domrefine | tsv_to_domclust.pl > cluster.domrefine.o0";
}
system "create_alignment_and_tree.pl cluster.domrefine";

system "echo end >> $LOG_FILE";
system "date >> $LOG_FILE";
system "domrefine_stat.pl > domrefine.stat";
