#!/usr/bin/perl -w
use strict;
use File::Basename;
use Getopt::Std;
my $PROGRAM = basename $0;
my $USAGE=
"Usage: $PROGRAM
";

my %OPT;
getopts('', \%OPT);

my $cluster = `cat cluster | cut.sh 1 | sort | uniq | wc -l | cut.sh 1`;
chomp($cluster);
my $cluster_split = `cat cluster | grep -v ' 0 ' | cut.sh 1 | sort | uniq | wc -l | cut.sh 1`;
chomp($cluster_split);
print "$cluster clusters\n";
print "$cluster_split/$cluster =",format_percent($cluster_split/$cluster)," clusters split\n";

if (-f "cluster.link.merged") {
    print "\nmerge\n";
    domrefine_stat("cluster.link.to_check",
		   "cluster.merge_test.summary",
		   "cluster.link.merged");
}
if (-f "cluster.merge.merge_divide_test.to_divide") {
    print "\nmerge_divide\n";
    domrefine_stat("cluster.merge.link",
		   "cluster.merge.merge_divide_test.summary",
		   "cluster.merge.merge_divide_test.to_divide");
}
if (-f "cluster.merge.merge_divide.moved") {
    print "\nmove_boundary\n";
    domrefine_stat("cluster.merge.merge_divide.link",
		   "cluster.merge.merge_divide.move_test.summary",
		   "cluster.merge.merge_divide.moved",
		   selected => "cluster.merge.merge_divide.move_test.to_move");
}
if (-f "cluster.merge.merge_divide.move.create_test.to_create" and -f "cluster.merge.merge_divide.move.link") {
    print "\ncreate_boundary\n";
    domrefine_stat("cluster.merge.merge_divide.move.link",
		   "cluster.merge.merge_divide.move.create_test.summary",
		   "cluster.merge.merge_divide.move.create_test.to_create");
}
if (-f "cluster.merge.merge_divide.move.create.divide_test.to_divide") {
    print "\ndivide\n";
    domrefine_stat("cluster.merge.merge_divide.move.create | cut.sh 1 | sort | uniq",
		   "cluster.merge.merge_divide.move.create.divide_test.summary",
		   "cluster.merge.merge_divide.move.create.divide_test.to_divide");

    my $cluster = `cat cluster.merge.merge_divide.move.create.divide | cut.sh 1 | sort | uniq | wc -l | cut.sh 1`;
    chomp($cluster);
    my $cluster_split = `cat cluster.merge.merge_divide.move.create.divide | dom_renumber -d | dom_renumber | grep -v ' 0 ' | cut.sh 1 | sort | uniq | wc -l | cut.sh 1`;
    chomp($cluster_split);
    print "$cluster clusters\n";
    printf "$cluster_split/$cluster =%.1f%% clusters split\n", $cluster_split/$cluster*100;

}

################################################################################
### Functions ##################################################################
################################################################################

sub domrefine_stat {
    my ($cluster, $cluster_summary, $cluster_to_modify, %opt) = @_;
    
    my $target = `cat $cluster | ignore_clusters.pl cluster.to_ignore | wc -l | cut.sh 1`;
    chomp($target);
    my $summary = `wc -l $cluster_summary | cut.sh 1`;
    chomp($summary);
    my $selected;
    if ($opt{selected}) {
	$selected = `wc -l $opt{selected} | cut.sh 1`;
	chomp($selected);
    }
    my $result = `wc -l $cluster_to_modify | cut.sh 1`;
    chomp($result);

    print "$summary/$target =",format_percent($summary/$target)," tested\n";
    if ($opt{selected}) {
	print "$selected/$target =",format_percent($selected/$target)," to be modified\n";
    }
    print "$result/$target =",format_percent($result/$target)," modified\n", ;
}

sub format_percent {
    my ($ratio) = @_;

    if ($ratio == 1) {
	return "100%";
    } else {
	return sprintf("%.1f%%", $ratio * 100);
    }
}
