#!/usr/bin/perl -w
use strict;
use File::Basename;
use Getopt::Std;
my $PROGRAM = basename $0;
my $USAGE=
"Usage: $PROGRAM [OPTION] CLUSTER_FILE
-e GAP_EXT
-o GAP_OPEN

Modify domain organizations: merge_divide_tree

Intermediate output files:
CLUSTER_FILE.link(|_eval|_eval.score.jobs|_eval.score.jobs.watch)
CLUSTER_FILE.merge_divide_test(|.jobs|.jobs.watch|.score.jobs|.score.jbos.watch|.summary)

Final output files:
CLUSTER_FILE.merge_divide(|.log)
";

my %OPT;
getopts('t:e:o:', \%OPT);

### Settings ###
my $OPTION = "";
if (defined $OPT{e}) {
    $OPTION .= " -e $OPT{e}";
}
if (defined $OPT{o}) {
    $OPTION .= " -o $OPT{o}";
}

my $SCORE = "dom_score_c";
$SCORE .= " -r"; # align by region
$SCORE .= $OPTION;

my $MERGE_DIVIDE = "dom_merge_divide_tree";
$MERGE_DIVIDE .= " -R"; # align only region

### Main ###
if (@ARGV == 0) {
    print STDERR $USAGE;
    exit 1;
}
my ($CLUSTER) = @ARGV;

### prepare ###
system "cat $CLUSTER | dom_network -l > $CLUSTER.link";
my $GET_CLUSTER = "cat $CLUSTER.link | ignore_clusters.pl cluster.to_ignore";
system "$GET_CLUSTER | sge_script.pl -R -i $CLUSTER -o $CLUSTER.link_eval -p score '$SCORE'";

### merge&divide on tree ###
system "$GET_CLUSTER | sge_script.pl -R -i $CLUSTER -o $CLUSTER.merge_divide_test '$MERGE_DIVIDE'";
system "$GET_CLUSTER | sge_script.pl -R -i $CLUSTER.merge_divide_test -o $CLUSTER.merge_divide_test -p score '$SCORE'";
system "$GET_CLUSTER | summarize_score.pl -i $CLUSTER.link_eval/score. -o $CLUSTER.merge_divide_test/score. > $CLUSTER.merge_divide_test.summary";
system "cat $CLUSTER.merge_divide_test.summary | sort -k4,4gr | select_positive.pl -f 4 > $CLUSTER.merge_divide_test.to_divide";
system "cat $CLUSTER.merge_divide_test.to_divide | modify_stepwise -i $CLUSTER -o $CLUSTER.merge_divide_test > $CLUSTER.merge_divide 2> $CLUSTER.merge_divide.log";
