#!/usr/bin/perl -w
use strict;
use File::Basename;
use Getopt::Std;
my $PROGRAM = basename $0;
my $USAGE=
"Usage: cat CLUSTER_LIST | $PROGRAM -o OUT_DIR
";

use DomRefine::Read;

### Settings ###
my %OPT;
getopts('o:', \%OPT);

my $SUB_DIR = $OPT{o} || die;;

### Main ###
-t and die $USAGE;
while (my $c = <STDIN>) {
    chomp($c);

    # read output file
    my $line = `cat $SUB_DIR/$c.log | grep '^i=' | head -1`;
    chomp($line);

    # modify the line
    $line =~ s/^i=(\d+)\S+/${c}\ti$1\t/;
    print $line, "\n";
}
